-----------------------------------------------------------------------
--         FILE:  xindex-cfg-common.lua
--  DESCRIPTION:  configuration file for xindex.lua
-- REQUIREMENTS:  
--       AUTHOR:  Herbert Voß
--      LICENSE:  LPPL1.3
--
-- $Id: xindex-cfg-common.lua 3 2026-02-07 17:48:32Z herbert $
-----------------------------------------------------------------------

if not modules then modules = { } end modules ['xindex-cfg-common'] = {
      version = 1.03,
      comment = "configuration to xindex.lua",
       author = "Herbert Voss",
    copyright = "Herbert Voss",
      license = "LPPL 1.3"
}

itemPageDelimiter = ","     -- Hello, 14
compressPages     = true    -- something like 12--15, instead of 12,13,14,15. the |( ... |) syntax is still valid
fCompress         = true    -- 3f -> page 3, 4 and 3ff -> page 3, 4, 5
minCompress       = 3       -- 14--17 or 
rangeSymbol       = "--"
numericPage       = true    -- for non numerical pagenumbers, like "VI-17"
sublabels         = {"", "-\\,", "--\\,", "---\\,"} -- for the (sub(sub(sub-items  first one is for item
pageNoPrefixDel   = ""     -- a delimiter for page numbers like "VI-17"  -- not used !!!
indexOpening      = ""     -- commands after envStart
idxnewletter      = "\\textbf"  -- Only valid if -n is not set
envStart          = "\\begin{theindex}"  
envStop           = "\\end{theindex}"


indexheader = { 
  cs = {"Symboly", "Čísla", "czech"},
  da = {"Symboler", "Tal", "danish"},
  de = {"Symbole", "Zahlen", "austrian", "german", "germanb", "ngerman", "naustrian"},
  en = {"Symbols", "Numbers", "english", "USenglish", "american", "UKenglish", "british", "canadian", "australian", "newzealand"},
  es = {"Símbolos", "Números", "spanish"},
  fr = {"Symboles","Nombres", "french", "francais", "canadien", "acadian"},
  it = {"Simboli", "Numeri", "italian"},
  jp = {"シンボル","番号", "japanese"},
  nl = {"Symbolen", "Nummers", "dutch"},
  no = {"Symboler","Tall", "norsk", "nynorsk"},
  ru = {"Символы", "Числа", "russian"}, 
}


--[[   babel
afrikaans
azerbaijani 
basque
breton
bulgarian
catalan
croatian
czech
danish
dutch
english, USenglish, american, UKenglish, british, canadian, australian, newzealand
esperanto
estonian
finnish
french, francais, canadien, acadian
galician
austrian, german, germanb, ngerman, naustrian
greek, polutonikogreek
hebrew
icelandic
indonesian (bahasa, indon, bahasai) 
interlingua
irish
italian
latin
lowersorbian
malay, melayu (bahasam)
samin
norsk, nynorsk
polish
portuguese
brazilian (portuges, brazil)
romanian
russian
scottish
spanish
slovak
slovene
swedish
serbian
turkish
ukrainian
uppersorbian
welsh
]]


folium = { 
  cs = {"f.", "ff."},
  da = {"f", "ff"},
  de = {"f", "ff"},
  en = {"f", "ff"},
  es = {"f", "ff"},
  fr = {"\\,sq.","\\,sqq."},
  it = {"f", "ff"},
  jp = {"シンボル","番号"},
  nl = {"f.", "ff."},
  no = {"\\,f.","\\,ff."},
  ru = {"",""},       -- doesn't exist
}

