/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import java.util.Date;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.scheduler.SchedulerEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;

public class SchedulerConsumer
extends ScheduledPollConsumer {
    public SchedulerConsumer(SchedulerEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    public SchedulerEndpoint getEndpoint() {
        return (SchedulerEndpoint)super.getEndpoint();
    }

    @Override
    protected int poll() throws Exception {
        return this.sendTimerExchange();
    }

    protected int sendTimerExchange() {
        final Exchange exchange = this.getEndpoint().createExchange();
        exchange.setProperty("CamelTimerName", this.getEndpoint().getName());
        Date now = new Date();
        exchange.setProperty("CamelTimerFiredTime", now);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Timer {} is firing", (Object)this.getEndpoint().getName());
        }
        if (!this.getEndpoint().isSynchronous()) {
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    if (exchange.getException() != null) {
                        SchedulerConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                    }
                }
            });
        } else {
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
            }
        }
        boolean polled = exchange.getProperty("CamelSchedulerPolledMessages", true, Boolean.TYPE);
        return polled ? 1 : 0;
    }

    @Override
    protected void doStart() throws Exception {
        this.getEndpoint().onConsumerStart(this);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.getEndpoint().onConsumerStop(this);
        super.doStop();
    }
}

