/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.concurrent.ThreadLocalRandom;

public class OptimisticLockRetryPolicy {
    private static final long DEFAULT_MAXIMUM_RETRY_DELAY = 1000L;
    private int maximumRetries;
    private long retryDelay = 50L;
    private long maximumRetryDelay;
    private boolean exponentialBackOff = true;
    private boolean randomBackOff;

    public boolean shouldRetry(int retryCounter) {
        return this.maximumRetries <= 0 || retryCounter < this.maximumRetries;
    }

    public void doDelay(int retryCounter) throws InterruptedException {
        long sleepFor = this.getDelay(retryCounter);
        if (sleepFor > 0L) {
            Thread.sleep(sleepFor);
        }
    }

    public long getDelay(int retryCounter) {
        long sleepFor = 0L;
        if (this.retryDelay > 0L || this.randomBackOff) {
            long l = this.exponentialBackOff ? this.retryDelay << retryCounter : (this.randomBackOff ? (long)ThreadLocalRandom.current().nextInt((int)(this.maximumRetryDelay > 0L ? this.maximumRetryDelay : 1000L)) : (sleepFor = this.retryDelay));
            if (this.maximumRetryDelay > 0L && sleepFor > this.maximumRetryDelay) {
                sleepFor = this.maximumRetryDelay;
            }
        }
        return sleepFor;
    }

    public int getMaximumRetries() {
        return this.maximumRetries;
    }

    public void setMaximumRetries(int maximumRetries) {
        this.maximumRetries = maximumRetries;
    }

    public OptimisticLockRetryPolicy maximumRetries(int maximumRetries) {
        this.setMaximumRetries(maximumRetries);
        return this;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public OptimisticLockRetryPolicy retryDelay(long retryDelay) {
        this.setRetryDelay(retryDelay);
        return this;
    }

    public long getMaximumRetryDelay() {
        return this.maximumRetryDelay;
    }

    public void setMaximumRetryDelay(long maximumRetryDelay) {
        this.maximumRetryDelay = maximumRetryDelay;
    }

    public OptimisticLockRetryPolicy maximumRetryDelay(long maximumRetryDelay) {
        this.setMaximumRetryDelay(maximumRetryDelay);
        return this;
    }

    public boolean isExponentialBackOff() {
        return this.exponentialBackOff;
    }

    public void setExponentialBackOff(boolean exponentialBackOff) {
        this.exponentialBackOff = exponentialBackOff;
    }

    public OptimisticLockRetryPolicy exponentialBackOff() {
        this.setExponentialBackOff(true);
        return this;
    }

    public boolean isRandomBackOff() {
        return this.randomBackOff;
    }

    public void setRandomBackOff(boolean randomBackOff) {
        this.randomBackOff = randomBackOff;
    }

    public OptimisticLockRetryPolicy randomBackOff() {
        this.setRandomBackOff(true);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("OptimisticLockRetryPolicy[");
        sb.append("maximumRetries=").append(this.maximumRetries);
        sb.append(", retryDelay=").append(this.retryDelay);
        sb.append(", maximumRetryDelay=").append(this.maximumRetryDelay);
        sb.append(", exponentialBackOff=").append(this.exponentialBackOff);
        sb.append(", randomBackOff=").append(this.randomBackOff);
        sb.append(']');
        return sb.toString();
    }
}

