/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.web;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.apache.aries.blueprint.parser.NamespaceHandlerSet;

public class BlueprintContextListener
implements ServletContextListener {
    public static final String CONTAINER_ATTRIBUTE = "org.apache.aries.blueprint.container";
    public static final String LOCATION = "blueprintLocation";
    public static final String PROPERTIES = "blueprintProperties";
    public static final String DEFAULT_LOCATION = "META-INF/blueprint.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        String location = servletContext.getInitParameter(LOCATION);
        if (location == null) {
            location = DEFAULT_LOCATION;
        }
        ArrayList<URL> resourcePaths = new ArrayList<URL>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources(location);
            while (resources.hasMoreElements()) {
                resourcePaths.add(resources.nextElement());
            }
            servletContext.log("Loading Blueprint contexts " + resourcePaths);
            HashMap<String, String> properties = new HashMap<String, String>();
            String propLocations = servletContext.getInitParameter(PROPERTIES);
            if (propLocations != null) {
                for (String propLoc : propLocations.split(",")) {
                    Enumeration<URL> propUrl = classLoader.getResources(propLoc);
                    while (propUrl.hasMoreElements()) {
                        URL url = propUrl.nextElement();
                        InputStream is = url.openStream();
                        try {
                            Properties props = new Properties();
                            props.load(is);
                            Enumeration<?> names = props.propertyNames();
                            while (names.hasMoreElements()) {
                                String key = names.nextElement().toString();
                                properties.put(key, props.getProperty(key));
                            }
                        }
                        finally {
                            is.close();
                        }
                    }
                }
            }
            NamespaceHandlerSet nsHandlerSet = this.getNamespaceHandlerSet(classLoader);
            BlueprintContainerImpl container = new BlueprintContainerImpl(classLoader, resourcePaths, properties, nsHandlerSet, true);
            servletContext.setAttribute(CONTAINER_ATTRIBUTE, (Object)container);
        }
        catch (Exception e) {
            servletContext.log("Failed to startup blueprint container. " + e, (Throwable)e);
        }
    }

    protected NamespaceHandlerSet getNamespaceHandlerSet(ClassLoader tccl) {
        return null;
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        Object container = servletContext.getAttribute(CONTAINER_ATTRIBUTE);
        if (container instanceof BlueprintContainerImpl) {
            BlueprintContainerImpl blueprint = (BlueprintContainerImpl)container;
            blueprint.destroy();
        }
    }
}

