/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.ResourceInstaller;
import org.apache.aries.subsystem.core.internal.ResourceReferences;
import org.apache.aries.subsystem.core.internal.SubsystemGraph;
import org.apache.aries.subsystem.core.internal.SubsystemIdentifier;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.apache.aries.subsystem.core.internal.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

public class Subsystems {
    private BasicSubsystem root;
    private volatile SubsystemGraph graph;
    private final Map<Long, BasicSubsystem> idToSubsystem = new HashMap<Long, BasicSubsystem>();
    private final Map<String, BasicSubsystem> locationToSubsystem = new HashMap<String, BasicSubsystem>();
    private final ResourceReferences resourceReferences = new ResourceReferences();
    private final Map<BasicSubsystem, Set<Resource>> subsystemToConstituents = new HashMap<BasicSubsystem, Set<Resource>>();

    public void addChild(BasicSubsystem parent, BasicSubsystem child, boolean referenceCount) {
        this.graph.add(parent, child);
        child.addedParent(parent, referenceCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstituent(BasicSubsystem subsystem, Resource constituent, boolean referenced) {
        Map<BasicSubsystem, Set<Resource>> map = this.subsystemToConstituents;
        synchronized (map) {
            Set<Resource> constituents = this.subsystemToConstituents.get(subsystem);
            if (constituents == null) {
                constituents = new HashSet<Resource>();
                this.subsystemToConstituents.put(subsystem, constituents);
            }
            constituents.add(constituent);
        }
        subsystem.addedConstituent(constituent, referenced);
    }

    public void addReference(BasicSubsystem subsystem, Resource resource) {
        this.resourceReferences.addReference(subsystem, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubsystem(BasicSubsystem subsystem) {
        Map<Long, BasicSubsystem> map = this.idToSubsystem;
        synchronized (map) {
            Map<String, BasicSubsystem> map2 = this.locationToSubsystem;
            synchronized (map2) {
                this.addIdToSubsystem(subsystem);
                this.addLocationToSubsystem(subsystem);
            }
        }
    }

    public Collection<Subsystem> getChildren(BasicSubsystem parent) {
        return this.graph.getChildren(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Resource> getConstituents(BasicSubsystem subsystem) {
        Map<BasicSubsystem, Set<Resource>> map = this.subsystemToConstituents;
        synchronized (map) {
            Collection result = this.subsystemToConstituents.get(subsystem);
            if (result == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableCollection(new ArrayList(result));
        }
    }

    public Collection<Subsystem> getParents(BasicSubsystem child) {
        return this.graph.getParents(child);
    }

    public Collection<Resource> getResourcesReferencedBy(BasicSubsystem subsystem) {
        return this.resourceReferences.getResources(subsystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BasicSubsystem getRootSubsystem() {
        if (this.root == null) {
            File file = Activator.getInstance().getBundleContext().getDataFile("");
            File[] fileArray = file.listFiles();
            ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(fileArray));
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    String name1 = file1.getName();
                    String name2 = file2.getName();
                    return Long.valueOf(name1).compareTo(Long.valueOf(name2));
                }
            });
            if (fileList.isEmpty()) {
                SubsystemResource resource;
                try {
                    resource = new SubsystemResource(file);
                }
                catch (SubsystemException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SubsystemException(e);
                }
                Coordination coordination = Utils.createCoordination();
                try {
                    this.root = new BasicSubsystem(resource);
                    this.graph = new SubsystemGraph(this.root);
                    ResourceInstaller.newInstance(coordination, this.root, this.root).install();
                    this.populateRootSubsystem(this.root, coordination);
                }
                catch (Exception e) {
                    coordination.fail((Throwable)e);
                }
                finally {
                    coordination.end();
                }
            } else {
                Coordination coordination = Utils.createCoordination();
                ArrayList<BasicSubsystem> subsystems = new ArrayList<BasicSubsystem>(fileList.size());
                try {
                    for (File f : fileList) {
                        BasicSubsystem s = new BasicSubsystem(f);
                        subsystems.add(s);
                        this.addSubsystem(s);
                    }
                    this.root = this.getSubsystemById(0L);
                    SubsystemIdentifier.setLastId(Long.parseLong(this.root.getDeploymentManifest().getHeaders().get("AriesSubsystem-LastId").getValue()));
                    this.graph = new SubsystemGraph(this.root);
                    ResourceInstaller.newInstance(coordination, this.root, this.root).install();
                    this.populateRootSubsystem(this.root, coordination);
                }
                catch (Exception e) {
                    coordination.fail((Throwable)e);
                }
                finally {
                    coordination.end();
                }
            }
        }
        return this.root;
    }

    private void populateRootSubsystem(BasicSubsystem root, Coordination coordination) throws Exception {
        BundleContext context = Activator.getInstance().getBundleContext().getBundle("System Bundle").getBundleContext();
        for (Bundle bundle : context.getBundles()) {
            BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (revision == null || !this.resourceReferences.getSubsystems((Resource)revision).isEmpty()) continue;
            ResourceInstaller.newInstance(coordination, (Resource)revision, root).install();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicSubsystem getSubsystemById(long id) {
        Map<Long, BasicSubsystem> map = this.idToSubsystem;
        synchronized (map) {
            return this.idToSubsystem.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicSubsystem getSubsystemByLocation(String location) {
        Map<String, BasicSubsystem> map = this.locationToSubsystem;
        synchronized (map) {
            return this.locationToSubsystem.get(location);
        }
    }

    public Collection<BasicSubsystem> getSubsystems() {
        return new ArrayList<BasicSubsystem>(this.idToSubsystem.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getSubsystemsByBundle(Bundle bundle) {
        BundleRevision revision = null;
        ArrayList<BasicSubsystem> result = new ArrayList<BasicSubsystem>();
        Map<BasicSubsystem, Set<Resource>> map = this.subsystemToConstituents;
        synchronized (map) {
            for (BasicSubsystem subsystem : this.subsystemToConstituents.keySet()) {
                for (Resource constituent : this.getConstituents(subsystem)) {
                    if (!(constituent instanceof BundleResourceInstaller.BundleConstituent) || ((BundleResourceInstaller.BundleConstituent)constituent).getBundle() != bundle) continue;
                    result.add(subsystem);
                    revision = ((BundleResourceInstaller.BundleConstituent)constituent).getRevision();
                }
            }
        }
        result.trimToSize();
        if (revision == null) {
            return null;
        }
        return new Object[]{revision, result};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BasicSubsystem> getSubsystemsByConstituent(Resource constituent) {
        ArrayList<BasicSubsystem> result = new ArrayList<BasicSubsystem>();
        Map<BasicSubsystem, Set<Resource>> map = this.subsystemToConstituents;
        synchronized (map) {
            for (BasicSubsystem subsystem : this.subsystemToConstituents.keySet()) {
                if (!this.getConstituents(subsystem).contains(constituent)) continue;
                result.add(subsystem);
            }
        }
        result.trimToSize();
        return result;
    }

    public Collection<BasicSubsystem> getSubsystemsReferencing(Resource resource) {
        return this.resourceReferences.getSubsystems(resource);
    }

    public void removeChild(BasicSubsystem child) {
        this.graph.remove(child);
    }

    public void removeChild(BasicSubsystem parent, BasicSubsystem child) {
        this.graph.remove(parent, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConstituent(BasicSubsystem subsystem, Resource constituent) {
        Map<BasicSubsystem, Set<Resource>> map = this.subsystemToConstituents;
        synchronized (map) {
            Set<Resource> constituents = this.subsystemToConstituents.get(subsystem);
            if (constituents != null) {
                constituents.remove(constituent);
                if (constituents.isEmpty()) {
                    this.subsystemToConstituents.remove(subsystem);
                }
            }
        }
        subsystem.removedContent(constituent);
    }

    public void removeReference(BasicSubsystem subsystem, Resource resource) {
        this.resourceReferences.removeReference(subsystem, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubsystem(BasicSubsystem subsystem) {
        Map<Long, BasicSubsystem> map = this.idToSubsystem;
        synchronized (map) {
            Map<String, BasicSubsystem> map2 = this.locationToSubsystem;
            synchronized (map2) {
                this.removeLocationToSubsystem(subsystem);
                this.removeIdToSubsystem(subsystem);
            }
        }
    }

    private void addIdToSubsystem(BasicSubsystem subsystem) {
        long id = subsystem.getSubsystemId();
        this.idToSubsystem.put(id, subsystem);
    }

    private void addLocationToSubsystem(BasicSubsystem subsystem) {
        String location = subsystem.getLocation();
        this.locationToSubsystem.put(location, subsystem);
    }

    private void removeIdToSubsystem(BasicSubsystem subsystem) {
        long id = subsystem.getSubsystemId();
        this.idToSubsystem.remove(id);
    }

    private void removeLocationToSubsystem(BasicSubsystem subsystem) {
        String location = subsystem.getLocation();
        this.locationToSubsystem.remove(location);
    }
}

