/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.jobgen.impl;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;

public class OperatorSchemaImpl
implements IOperatorSchema {
    private final Object2IntMap<LogicalVariable> varMap = new Object2IntOpenHashMap();
    private final List<LogicalVariable> varList = new ArrayList<LogicalVariable>();

    @Override
    public void addAllVariables(IOperatorSchema source) {
        for (LogicalVariable v : source) {
            this.addVariable(v);
        }
    }

    @Override
    public void addAllNewVariables(IOperatorSchema source) {
        int sourceLen = source.getSize();
        BitSet newVarIdxs = null;
        block0: for (int i = 0; i < sourceLen; ++i) {
            LogicalVariable v = source.getVariable(i);
            if (!this.varMap.containsKey((Object)v)) {
                this.addVariable(v);
                if (newVarIdxs == null) {
                    newVarIdxs = new BitSet(sourceLen);
                }
                newVarIdxs.set(i);
                continue;
            }
            if (newVarIdxs == null) continue;
            int j = newVarIdxs.nextSetBit(0);
            while (j >= 0) {
                if (v.equals(source.getVariable(j))) {
                    this.addVariable(v);
                    continue block0;
                }
                j = newVarIdxs.nextSetBit(j + 1);
            }
        }
    }

    @Override
    public int addVariable(LogicalVariable var) {
        int idx = this.varList.size();
        this.varMap.put((Object)var, idx);
        this.varList.add(var);
        return idx;
    }

    @Override
    public void clear() {
        this.varMap.clear();
        this.varList.clear();
    }

    @Override
    public int findVariable(LogicalVariable var) {
        Integer i = this.varMap.get((Object)var);
        if (i == null) {
            return -1;
        }
        return i;
    }

    @Override
    public int getSize() {
        return this.varList.size();
    }

    @Override
    public LogicalVariable getVariable(int index) {
        return this.varList.get(index);
    }

    @Override
    public Iterator<LogicalVariable> iterator() {
        return this.varList.iterator();
    }

    public String toString() {
        return this.varMap + " " + this.varList;
    }
}

