/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.function.LongSupplier;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.asterix.external.input.record.RecordWithMetadataAndPK;
import org.apache.asterix.external.input.record.converter.IRecordToRecordWithMetadataAndPKConverter;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.dataflow.std.file.FieldCursorForDelimitedDataParser;

public class CSVToRecordWithMetadataAndPKConverter
implements IRecordToRecordWithMetadataAndPKConverter<char[], char[]> {
    private final FieldCursorForDelimitedDataParser cursor;
    private final int valueIndex;
    private final RecordWithMetadataAndPK<char[]> recordWithMetadata;
    private final CharArrayRecord record;
    private LongSupplier lineNumber = ExternalDataConstants.NO_LINES;

    public CSVToRecordWithMetadataAndPKConverter(int valueIndex, char delimiter, ARecordType metaType, ARecordType recordType, int[] keyIndicator, int[] keyIndexes, IAType[] keyTypes, IWarningCollector warningCollector) {
        this.cursor = new FieldCursorForDelimitedDataParser(null, delimiter, '\"', warningCollector, ExternalDataConstants.EMPTY_STRING);
        this.record = new CharArrayRecord();
        this.valueIndex = valueIndex;
        this.recordWithMetadata = new RecordWithMetadataAndPK<char[]>(this.record, metaType.getFieldTypes(), recordType, keyIndicator, keyIndexes, keyTypes);
    }

    @Override
    public RecordWithMetadataAndPK<char[]> convert(IRawRecord<? extends char[]> input) throws IOException {
        FieldCursorForDelimitedDataParser.Result lastResult;
        this.record.reset();
        this.recordWithMetadata.reset();
        this.cursor.nextRecord(input.get(), input.size(), this.lineNumber.getAsLong());
        int i = 0;
        int j = 0;
        while ((lastResult = this.cursor.nextField()) == FieldCursorForDelimitedDataParser.Result.OK) {
            if (this.cursor.fieldHasDoubleQuote()) {
                this.cursor.eliminateDoubleQuote();
            }
            if (i == this.valueIndex) {
                this.record.setValue(this.cursor.getBuffer(), this.cursor.getFieldStart(), this.cursor.getFieldLength());
                this.record.endRecord();
            } else {
                this.recordWithMetadata.setRawMetadata(j, this.cursor.getBuffer(), this.cursor.getFieldStart(), this.cursor.getFieldLength());
                ++j;
            }
            ++i;
        }
        if (lastResult == FieldCursorForDelimitedDataParser.Result.ERROR) {
            throw new RuntimeDataException(3113, new Serializable[0]);
        }
        return this.recordWithMetadata;
    }

    @Override
    public void configure(LongSupplier lineNumber) {
        this.lineNumber = lineNumber == null ? ExternalDataConstants.NO_LINES : lineNumber;
    }
}

