/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class CardinalityInferenceVisitor
implements ILogicalOperatorVisitor<Long, Void> {
    private static final long ZERO_OR_ONE = 0L;
    private static final long ONE = 1L;
    private static final long ZERO_OR_ONE_GROUP = 2L;
    private static final long ONE_GROUP = 3L;
    private static final long UNKNOWN = 100L;
    private final Set<LogicalVariable> keyVariables = new HashSet<LogicalVariable>();

    private CardinalityInferenceVisitor() {
    }

    @Override
    public Long visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
        return 1L;
    }

    @Override
    public Long visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
        return 1L;
    }

    @Override
    public Long visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        if (op.isGroupAll()) {
            return 1L;
        }
        ILogicalOperator inputOp = (ILogicalOperator)op.getInputs().get(0).getValue();
        long inputCardinality = inputOp.accept(this, arg);
        List<LogicalVariable> gbyVar = op.getGroupByVarList();
        if (inputCardinality == 3L && this.keyVariables.containsAll(gbyVar)) {
            this.keyVariables.clear();
            return 1L;
        }
        if (inputCardinality == 2L && this.keyVariables.containsAll(gbyVar)) {
            this.keyVariables.clear();
            return 0L;
        }
        return inputCardinality;
    }

    @Override
    public Long visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
        return this.adjustCardinalityForTupleReductionOperator(((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg));
    }

    @Override
    public Long visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
        return this.visitInnerJoin(op, arg);
    }

    @Override
    public Long visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
        return this.visitLeftOuterUnnest(op, arg);
    }

    @Override
    public Long visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getDataSourceReference().getValue()).getOperatorTag() == LogicalOperatorTag.SUBPLAN ? 1L : 100L;
    }

    @Override
    public Long visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
        return this.adjustCardinalityForTupleReductionOperator(((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg));
    }

    @Override
    public Long visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
        return 100L;
    }

    @Override
    public Long visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
        this.keyVariables.retainAll(op.getVariables());
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
        return 100L;
    }

    @Override
    public Long visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitSinkOperator(SinkOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
        return 100L;
    }

    @Override
    public Long visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
        return 100L;
    }

    @Override
    public Long visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
        return this.visitLeftOuterUnnest(op, arg);
    }

    @Override
    public Long visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
        return 100L;
    }

    @Override
    public Long visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
        return this.visitLeftOuterUnnest(op, arg);
    }

    @Override
    public Long visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
        return 100L;
    }

    @Override
    public Long visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitWriteOperator(WriteOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitDistributeResultOperator(DistributeResultOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitWriteResultOperator(WriteResultOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitTokenizeOperator(TokenizeOperator op, Void arg) throws AlgebricksException {
        return 100L;
    }

    @Override
    public Long visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
        return ((ILogicalOperator)op.getInputs().get(0).getValue()).accept(this, arg);
    }

    @Override
    public Long visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
        long cardinality = 100L;
        for (Mutable<ILogicalOperator> inputOpRef : op.getInputs()) {
            long inputCardinality = ((ILogicalOperator)inputOpRef.getValue()).accept(this, arg);
            if (inputCardinality <= 1L) {
                return 0L;
            }
            if (inputCardinality != 2L && inputCardinality != 3L) continue;
            cardinality = 2L;
        }
        return cardinality;
    }

    private long visitLeftOuterUnnest(ILogicalOperator operator, Void arg) throws AlgebricksException {
        ILogicalOperator left = (ILogicalOperator)operator.getInputs().get(0).getValue();
        long leftCardinality = left.accept(this, arg);
        if (leftCardinality == 1L) {
            this.keyVariables.clear();
            VariableUtilities.getLiveVariables(left, this.keyVariables);
            return 3L;
        }
        if (leftCardinality == 0L) {
            this.keyVariables.clear();
            VariableUtilities.getLiveVariables(left, this.keyVariables);
            return 2L;
        }
        return leftCardinality;
    }

    private long visitInnerJoin(InnerJoinOperator joinOperator, Void arg) throws AlgebricksException {
        ILogicalExpression conditionExpr = (ILogicalExpression)joinOperator.getCondition().getValue();
        if (!conditionExpr.equals(ConstantExpression.TRUE)) {
            return 100L;
        }
        HashSet<LogicalVariable> newKeyVars = new HashSet<LogicalVariable>();
        ILogicalOperator left = (ILogicalOperator)joinOperator.getInputs().get(0).getValue();
        long leftCardinality = left.accept(this, arg);
        newKeyVars.addAll(this.keyVariables);
        ILogicalOperator right = (ILogicalOperator)joinOperator.getInputs().get(1).getValue();
        long rightCardinality = right.accept(this, arg);
        newKeyVars.addAll(this.keyVariables);
        if (leftCardinality == 0L && rightCardinality == 0L) {
            return 0L;
        }
        if (leftCardinality == 1L && rightCardinality == 1L) {
            return 1L;
        }
        this.keyVariables.clear();
        if (leftCardinality == 0L || rightCardinality == 0L) {
            VariableUtilities.getLiveVariables(leftCardinality == 1L ? left : right, this.keyVariables);
            return 2L;
        }
        if (leftCardinality == 1L || rightCardinality == 1L) {
            VariableUtilities.getLiveVariables(leftCardinality == 1L ? left : right, this.keyVariables);
            return 3L;
        }
        if (leftCardinality == 3L || rightCardinality == 3L || leftCardinality == 2L || rightCardinality == 2L) {
            this.keyVariables.addAll(newKeyVars);
            return Math.min(leftCardinality, rightCardinality);
        }
        return 100L;
    }

    private long adjustCardinalityForTupleReductionOperator(long inputCardinality) {
        if (inputCardinality == 1L) {
            return 0L;
        }
        if (inputCardinality == 3L) {
            return 2L;
        }
        return inputCardinality;
    }

    public static boolean isCardinalityExactOne(ILogicalOperator operator) throws AlgebricksException {
        CardinalityInferenceVisitor visitor = new CardinalityInferenceVisitor();
        long cardinality = operator.accept(visitor, null);
        return cardinality == 1L;
    }

    public static boolean isCardinalityZeroOrOne(ILogicalOperator operator) throws AlgebricksException {
        CardinalityInferenceVisitor visitor = new CardinalityInferenceVisitor();
        long cardinality = operator.accept(visitor, null);
        return cardinality == 0L || cardinality == 1L;
    }
}

