/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.partitions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.io.IWritable;
import org.apache.hyracks.api.job.JobId;

public final class PartitionId
implements IWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private JobId jobId;
    private ConnectorDescriptorId cdId;
    private int senderIndex;
    private int receiverIndex;

    public static PartitionId create(DataInput dis) throws IOException {
        PartitionId partitionId = new PartitionId();
        partitionId.readFields(dis);
        return partitionId;
    }

    private PartitionId() {
    }

    public PartitionId(JobId jobId, ConnectorDescriptorId cdId, int senderIndex, int receiverIndex) {
        this.jobId = jobId;
        this.cdId = cdId;
        this.senderIndex = senderIndex;
        this.receiverIndex = receiverIndex;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public ConnectorDescriptorId getConnectorDescriptorId() {
        return this.cdId;
    }

    public int getSenderIndex() {
        return this.senderIndex;
    }

    public int getReceiverIndex() {
        return this.receiverIndex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cdId == null ? 0 : this.cdId.hashCode());
        result = 31 * result + (this.jobId == null ? 0 : this.jobId.hashCode());
        result = 31 * result + this.receiverIndex;
        result = 31 * result + this.senderIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionId other = (PartitionId)obj;
        if (this.cdId == null ? other.cdId != null : !this.cdId.equals(other.cdId)) {
            return false;
        }
        if (this.jobId == null ? other.jobId != null : !this.jobId.equals(other.jobId)) {
            return false;
        }
        if (this.receiverIndex != other.receiverIndex) {
            return false;
        }
        return this.senderIndex == other.senderIndex;
    }

    public String toString() {
        return this.jobId.toString() + ":" + this.cdId + ":" + this.senderIndex + ":" + this.receiverIndex;
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        this.cdId.writeFields(output);
        this.jobId.writeFields(output);
        output.writeInt(this.receiverIndex);
        output.writeInt(this.senderIndex);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.cdId = ConnectorDescriptorId.create(input);
        this.jobId = JobId.create(input);
        this.receiverIndex = input.readInt();
        this.senderIndex = input.readInt();
    }
}

