/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.PrimaryKeyVariablesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.rewriter.util.PhysicalOptimizationsUtil;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class EquivalenceClassUtils {
    public static final String REWRITE_INTERNAL_QUERYUID_PK = "rewrite_internal_queryuid_pk";
    static final boolean REWRITE_INTERNAL_QUERYUID_PK_DEFAULT = true;

    public static void addEquivalenceClassesForPrimaryIndexAccess(ILogicalOperator operator, List<LogicalVariable> indexSearchVars, ARecordType recordType, ARecordType metaRecordType, Dataset dataset, IOptimizationContext context) throws AlgebricksException {
        if (dataset.getDatasetDetails().getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
            return;
        }
        InternalDatasetDetails datasetDetails = (InternalDatasetDetails)dataset.getDatasetDetails();
        List primaryKey = datasetDetails.getPrimaryKey();
        HashMap<String, Integer> fieldNameToIndexMap = new HashMap<String, Integer>();
        String[] fieldNames = recordType.getFieldNames();
        for (int fieldIndex = 0; fieldIndex < fieldNames.length; ++fieldIndex) {
            fieldNameToIndexMap.put(fieldNames[fieldIndex], fieldIndex);
        }
        boolean hasMeta = dataset.hasMetaPart();
        HashMap<String, Integer> metaFieldNameToIndexMap = new HashMap<String, Integer>();
        if (hasMeta) {
            String[] metaFieldNames = metaRecordType.getFieldNames();
            for (int metaFieldIndex = 0; metaFieldIndex < metaFieldNames.length; ++metaFieldIndex) {
                metaFieldNameToIndexMap.put(metaFieldNames[metaFieldIndex], metaFieldIndex);
            }
        }
        List keySourceIndicators = datasetDetails.getKeySourceIndicator();
        LogicalVariable recordVar = hasMeta ? indexSearchVars.get(indexSearchVars.size() - 2) : indexSearchVars.get(indexSearchVars.size() - 1);
        LogicalVariable metaRecordVar = hasMeta ? indexSearchVars.get(indexSearchVars.size() - 1) : null;
        for (int pkIndex = 0; pkIndex < primaryKey.size(); ++pkIndex) {
            Integer fieldIndexInRecord;
            LogicalVariable referredRecordVar = recordVar;
            String pkFieldName = (String)((List)primaryKey.get(pkIndex)).get(0);
            int source = (Integer)keySourceIndicators.get(pkIndex);
            if (source == 0) {
                fieldIndexInRecord = (Integer)fieldNameToIndexMap.get(pkFieldName);
            } else {
                referredRecordVar = metaRecordVar;
                fieldIndexInRecord = (Integer)metaFieldNameToIndexMap.get(pkFieldName);
            }
            LogicalVariable var = indexSearchVars.get(pkIndex);
            VariableReferenceExpression referredRecordVarRef = new VariableReferenceExpression(referredRecordVar);
            referredRecordVarRef.setSourceLocation(operator.getSourceLocation());
            ScalarFunctionCallExpression expr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{new MutableObject((Object)referredRecordVarRef), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(fieldIndexInRecord.intValue()))))});
            expr.setSourceLocation(operator.getSourceLocation());
            EquivalenceClass equivClass = new EquivalenceClass(Collections.singletonList(var), var, Collections.singletonList(expr));
            HashMap<LogicalVariable, EquivalenceClass> equivalenceMap = context.getEquivalenceClassMap(operator);
            if (equivalenceMap == null) {
                equivalenceMap = new HashMap<LogicalVariable, EquivalenceClass>();
                context.putEquivalenceClassMap(operator, equivalenceMap);
            }
            equivalenceMap.put(var, equivClass);
        }
    }

    public static Triple<Set<LogicalVariable>, ILogicalOperator, FunctionalDependency> findOrCreatePrimaryKeyOpAndVariables(ILogicalOperator operator, boolean usedForCorrelationJoin, IOptimizationContext context) throws AlgebricksException {
        LinkedHashSet liveVars = new LinkedHashSet();
        VariableUtilities.getSubplanLocalLiveVariables((ILogicalOperator)operator, liveVars);
        LinkedHashSet primaryKeyVars = new LinkedHashSet();
        LinkedHashSet<LogicalVariable> noKeyVars = new LinkedHashSet<LogicalVariable>();
        for (LogicalVariable liveVar : liveVars) {
            List keyVars = context.findPrimaryKey(liveVar);
            if (keyVars != null) {
                keyVars.retainAll(liveVars);
            }
            if (keyVars == null || keyVars.isEmpty()) {
                noKeyVars.add(liveVar);
                continue;
            }
            primaryKeyVars.addAll(keyVars);
        }
        primaryKeyVars.retainAll(liveVars);
        if (primaryKeyVars.containsAll(noKeyVars)) {
            return new Triple(primaryKeyVars, null, null);
        }
        if (!usedForCorrelationJoin && EquivalenceClassUtils.isQueryUidPkEnabled(context)) {
            LogicalVariable idVar = context.newVar();
            RunningAggregateOperator assignIdOp = new RunningAggregateOperator(idVar, (Mutable)new MutableObject((Object)new StatefulFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_QUERY_UID), null)));
            assignIdOp.setSourceLocation(operator.getSourceLocation());
            assignIdOp.getInputs().add(new MutableObject((Object)operator));
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignIdOp);
            FunctionalDependency primaryKeyFD = new FunctionalDependency(Collections.singletonList(idVar), new ArrayList(liveVars));
            return new Triple(Collections.singleton(idVar), (Object)assignIdOp, (Object)primaryKeyFD);
        }
        noKeyVars.removeAll(primaryKeyVars);
        ArrayList partitionVarRefs = new ArrayList(primaryKeyVars.size() + noKeyVars.size());
        OperatorManipulationUtil.createVariableReferences(primaryKeyVars, (SourceLocation)operator.getSourceLocation(), partitionVarRefs);
        OperatorManipulationUtil.createVariableReferences(noKeyVars, (SourceLocation)operator.getSourceLocation(), partitionVarRefs);
        LogicalVariable rowNumVar = context.newVar();
        AbstractFunctionCallExpression rowNumExpr = BuiltinFunctions.makeWindowFunctionExpression((FunctionIdentifier)BuiltinFunctions.ROW_NUMBER_IMPL, Collections.emptyList());
        WindowOperator winOp = new WindowOperator(partitionVarRefs, Collections.emptyList());
        winOp.getVariables().add(rowNumVar);
        winOp.getExpressions().add(new MutableObject((Object)rowNumExpr));
        winOp.setSourceLocation(operator.getSourceLocation());
        winOp.getInputs().add(new MutableObject((Object)operator));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)winOp);
        primaryKeyVars.addAll(noKeyVars);
        primaryKeyVars.add(rowNumVar);
        FunctionalDependency primaryKeyFD = new FunctionalDependency(new ArrayList(primaryKeyVars), new ArrayList(liveVars));
        return new Triple(primaryKeyVars, (Object)winOp, (Object)primaryKeyFD);
    }

    public static void computePrimaryKeys(ILogicalOperator op, IOptimizationContext ctx) throws AlgebricksException {
        PrimaryKeyVariablesVisitor visitor = new PrimaryKeyVariablesVisitor();
        PhysicalOptimizationsUtil.visitOperatorAndItsDescendants((ILogicalOperator)op, (ILogicalOperatorVisitor)visitor, (IOptimizationContext)ctx);
    }

    private static boolean isQueryUidPkEnabled(IOptimizationContext context) {
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        return metadataProvider.getBooleanProperty(REWRITE_INTERNAL_QUERYUID_PK, true);
    }
}

