/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.rewrites.VariableSubstitutionEnvironment;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.CloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.common.visitor.base.AbstractQueryExpressionVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.SourceLocation;

public abstract class AbstractInlineUdfsVisitor
extends AbstractQueryExpressionVisitor<Boolean, Void> {
    protected final LangRewritingContext context;
    protected final Map<FunctionSignature, FunctionDecl> usedUDFs;
    protected final CloneAndSubstituteVariablesVisitor cloneVisitor;

    public AbstractInlineUdfsVisitor(LangRewritingContext context, Map<FunctionSignature, FunctionDecl> usedUDFs, CloneAndSubstituteVariablesVisitor cloneVisitor) {
        this.context = context;
        this.usedUDFs = usedUDFs;
        this.cloneVisitor = cloneVisitor;
    }

    protected abstract Expression generateQueryExpression(List<LetClause> var1, Expression var2) throws CompilationException;

    @Override
    public Boolean visit(Query q, Void arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(q.getBody());
        q.setBody((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(FunctionDecl fd, Void arg) throws CompilationException {
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, fd.getSourceLocation(), new Serializable[]{fd.getSignature().toString()});
    }

    @Override
    public Boolean visit(ListConstructor lc, Void arg) throws CompilationException {
        Pair<Boolean, List<Expression>> p = this.inlineUdfsInExprList(lc.getExprList());
        lc.setExprList((List)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(RecordConstructor rc, Void arg) throws CompilationException {
        boolean changed = false;
        for (FieldBinding b : rc.getFbList()) {
            Pair<Boolean, Expression> leftExprInlined = this.inlineUdfsInExpr(b.getLeftExpr());
            b.setLeftExpr((Expression)leftExprInlined.second);
            changed = changed || (Boolean)leftExprInlined.first != false;
            Pair<Boolean, Expression> rightExprInlined = this.inlineUdfsInExpr(b.getRightExpr());
            b.setRightExpr((Expression)rightExprInlined.second);
            changed = changed || (Boolean)rightExprInlined.first != false;
        }
        return changed;
    }

    @Override
    public Boolean visit(CallExpr callExpr, Void arg) throws CompilationException {
        Pair<Boolean, List<Expression>> p = this.inlineUdfsInExprList(callExpr.getExprList());
        callExpr.setExprList((List)p.second);
        boolean changed = (Boolean)p.first;
        if (callExpr.hasAggregateFilterExpr()) {
            Pair<Boolean, Expression> be = this.inlineUdfsInExpr(callExpr.getAggregateFilterExpr());
            callExpr.setAggregateFilterExpr((Expression)be.second);
            changed |= ((Boolean)be.first).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(OperatorExpr ifbo, Void arg) throws CompilationException {
        Pair<Boolean, List<Expression>> p = this.inlineUdfsInExprList(ifbo.getExprList());
        ifbo.setExprList((List)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(FieldAccessor fa, Void arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(fa.getExpr());
        fa.setExpr((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(IndexAccessor fa, Void arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(fa.getExpr());
        fa.setExpr((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(IfExpr ifexpr, Void arg) throws CompilationException {
        Pair<Boolean, Expression> p1 = this.inlineUdfsInExpr(ifexpr.getCondExpr());
        ifexpr.setCondExpr((Expression)p1.second);
        Pair<Boolean, Expression> p2 = this.inlineUdfsInExpr(ifexpr.getThenExpr());
        ifexpr.setThenExpr((Expression)p2.second);
        Pair<Boolean, Expression> p3 = this.inlineUdfsInExpr(ifexpr.getElseExpr());
        ifexpr.setElseExpr((Expression)p3.second);
        return (Boolean)p1.first != false || (Boolean)p2.first != false || (Boolean)p3.first != false;
    }

    @Override
    public Boolean visit(QuantifiedExpression qe, Void arg) throws CompilationException {
        boolean changed = false;
        for (QuantifiedPair t : qe.getQuantifiedList()) {
            Pair<Boolean, Expression> p = this.inlineUdfsInExpr(t.getExpr());
            t.setExpr((Expression)p.second);
            if (!((Boolean)p.first).booleanValue()) continue;
            changed = true;
        }
        Pair<Boolean, Expression> p2 = this.inlineUdfsInExpr(qe.getSatisfiesExpr());
        qe.setSatisfiesExpr((Expression)p2.second);
        return changed || (Boolean)p2.first != false;
    }

    @Override
    public Boolean visit(LetClause lc, Void arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(lc.getBindingExpr());
        lc.setBindingExpr((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(WhereClause wc, Void arg) throws CompilationException {
        Pair<Boolean, Expression> p = this.inlineUdfsInExpr(wc.getWhereExpr());
        wc.setWhereExpr((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(OrderbyClause oc, Void arg) throws CompilationException {
        Pair<Boolean, List<Expression>> p = this.inlineUdfsInExprList(oc.getOrderbyList());
        oc.setOrderbyList((List)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(GroupbyClause gc, Void arg) throws CompilationException {
        boolean changed = false;
        List<List<GbyVariableExpressionPair>> gbyList = gc.getGbyPairList();
        ArrayList<List<GbyVariableExpressionPair>> newGbyList = new ArrayList<List<GbyVariableExpressionPair>>(gbyList.size());
        for (List<GbyVariableExpressionPair> gbyPairList : gbyList) {
            Pair<Boolean, List<GbyVariableExpressionPair>> p1 = this.inlineUdfsInGbyPairList(gbyPairList);
            newGbyList.add((List)p1.second);
            changed |= ((Boolean)p1.first).booleanValue();
        }
        gc.setGbyPairList(newGbyList);
        if (gc.hasDecorList()) {
            Pair<Boolean, List<GbyVariableExpressionPair>> p2 = this.inlineUdfsInGbyPairList(gc.getDecorPairList());
            gc.setDecorPairList((List)p2.second);
            changed |= ((Boolean)p2.first).booleanValue();
        }
        if (gc.hasGroupFieldList()) {
            Pair<Boolean, List<Pair<Expression, Identifier>>> p3 = this.inlineUdfsInFieldList(gc.getGroupFieldList());
            gc.setGroupFieldList((List)p3.second);
            changed |= ((Boolean)p3.first).booleanValue();
        }
        if (gc.hasWithMap()) {
            Pair<Boolean, Map<Expression, VariableExpr>> p4 = this.inlineUdfsInVarMap(gc.getWithVarMap());
            gc.setWithVarMap((Map)p4.second);
            changed |= ((Boolean)p4.first).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(LimitClause lc, Void arg) throws CompilationException {
        boolean changed = false;
        if (lc.hasLimitExpr()) {
            Pair<Boolean, Expression> p1 = this.inlineUdfsInExpr(lc.getLimitExpr());
            lc.setLimitExpr((Expression)p1.second);
            changed = (Boolean)p1.first;
        }
        if (lc.hasOffset()) {
            Pair<Boolean, Expression> p2 = this.inlineUdfsInExpr(lc.getOffset());
            lc.setOffset((Expression)p2.second);
            changed |= ((Boolean)p2.first).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(UnaryExpr u, Void arg) throws CompilationException {
        return u.getExpr().accept(this, arg);
    }

    @Override
    public Boolean visit(VariableExpr v, Void arg) throws CompilationException {
        return false;
    }

    @Override
    public Boolean visit(LiteralExpr l, Void arg) throws CompilationException {
        return false;
    }

    @Override
    public Boolean visit(InsertStatement insert, Void arg) throws CompilationException {
        boolean changed = false;
        Expression returnExpression = insert.getReturnExpression();
        if (returnExpression != null) {
            Pair<Boolean, Expression> rewrittenReturnExpr = this.inlineUdfsInExpr(returnExpression);
            insert.setReturnExpression((Expression)rewrittenReturnExpr.second);
            changed |= ((Boolean)rewrittenReturnExpr.first).booleanValue();
        }
        Pair<Boolean, Expression> rewrittenBodyExpression = this.inlineUdfsInExpr(insert.getBody());
        insert.setBody((Expression)rewrittenBodyExpression.second);
        return changed || (Boolean)rewrittenBodyExpression.first != false;
    }

    protected Pair<Boolean, Expression> inlineUdfsInExpr(Expression expr) throws CompilationException {
        LetClause c;
        if (expr.getKind() != Expression.Kind.CALL_EXPRESSION) {
            boolean r = expr.accept(this, null);
            return new Pair((Object)r, (Object)expr);
        }
        CallExpr f = (CallExpr)expr;
        boolean r = expr.accept(this, null);
        FunctionSignature fs = f.getFunctionSignature();
        if (FunctionUtil.isBuiltinFunctionSignature(fs)) {
            return new Pair((Object)r, (Object)expr);
        }
        if (f.hasAggregateFilterExpr()) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_USE_OF_FILTER_CLAUSE, f.getSourceLocation(), new Serializable[0]);
        }
        FunctionDecl implem = this.usedUDFs.get(fs);
        if (implem == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_FUNCTION, f.getSourceLocation(), new Serializable[]{fs.toString()});
        }
        List<Expression> argList = f.getExprList();
        int argCount = argList.size();
        ArrayList<LetClause> clauses = new ArrayList<LetClause>(argCount + 1);
        ArrayList<Expression> argVars = new ArrayList<Expression>(argCount);
        for (Expression e : f.getExprList()) {
            VarIdentifier argVar;
            if (e.getKind() == Expression.Kind.VARIABLE_EXPRESSION) {
                argVar = ((VariableExpr)e).getVar();
            } else {
                SourceLocation sourceLoc = e.getSourceLocation();
                argVar = this.context.newVariable();
                Pair<ILangExpression, VariableSubstitutionEnvironment> p1 = e.accept(this.cloneVisitor, new VariableSubstitutionEnvironment());
                VariableExpr newVRef1 = new VariableExpr(argVar);
                newVRef1.setSourceLocation(sourceLoc);
                c = new LetClause(newVRef1, (Expression)p1.first);
                c.setSourceLocation(sourceLoc);
                clauses.add(c);
            }
            VariableExpr argVarExpr = new VariableExpr(argVar);
            argVarExpr.setSourceLocation(e.getSourceLocation());
            argVars.add(argVarExpr);
        }
        VariableSubstitutionEnvironment subst = new VariableSubstitutionEnvironment();
        List<VarIdentifier> paramList = implem.getParamList();
        if (implem.getSignature().getArity() == -1) {
            if (paramList.size() != 1) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, expr.getSourceLocation(), new Serializable[]{Integer.valueOf(paramList.size())});
            }
            VarIdentifier paramVarargs = paramList.get(0);
            CallExpr argsListExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.ORDERED_LIST_CONSTRUCTOR), argVars);
            argsListExpr.setSourceLocation(expr.getSourceLocation());
            VarIdentifier argsVar = this.context.newVariable();
            VariableExpr argsVarRef1 = new VariableExpr(argsVar);
            argsVarRef1.setSourceLocation(expr.getSourceLocation());
            c = new LetClause(argsVarRef1, argsListExpr);
            c.setSourceLocation(expr.getSourceLocation());
            clauses.add(c);
            VariableExpr argsVarRef2 = new VariableExpr(argsVar);
            argsVarRef2.setSourceLocation(expr.getSourceLocation());
            subst.addSubstituion(new VariableExpr(paramVarargs), argsVarRef2);
        } else {
            if (paramList.size() != argCount) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, expr.getSourceLocation(), new Serializable[]{Integer.valueOf(paramList.size())});
            }
            for (int i = 0; i < argCount; ++i) {
                subst.addSubstituion(new VariableExpr(paramList.get(i)), (Expression)argVars.get(i));
            }
        }
        Expression funcBodyNorm = implem.getNormalizedFuncBody();
        if (funcBodyNorm == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, f.getSourceLocation(), new Serializable[]{fs.toString()});
        }
        Pair<ILangExpression, VariableSubstitutionEnvironment> p2 = funcBodyNorm.accept(this.cloneVisitor, subst);
        Expression resExpr = clauses.isEmpty() ? (Expression)p2.first : this.generateQueryExpression(clauses, (Expression)p2.first);
        return new Pair((Object)true, (Object)resExpr);
    }

    protected Pair<Boolean, List<Expression>> inlineUdfsInExprList(List<Expression> exprList) throws CompilationException {
        ArrayList<Expression> newList = new ArrayList<Expression>(exprList.size());
        boolean changed = false;
        for (Expression e : exprList) {
            Pair<Boolean, Expression> be = this.inlineUdfsInExpr(e);
            newList.add((Expression)be.second);
            changed |= ((Boolean)be.first).booleanValue();
        }
        return new Pair((Object)changed, newList);
    }

    private Pair<Boolean, List<GbyVariableExpressionPair>> inlineUdfsInGbyPairList(List<GbyVariableExpressionPair> gbyPairList) throws CompilationException {
        ArrayList<GbyVariableExpressionPair> newList = new ArrayList<GbyVariableExpressionPair>(gbyPairList.size());
        boolean changed = false;
        for (GbyVariableExpressionPair p : gbyPairList) {
            Pair<Boolean, Expression> be = this.inlineUdfsInExpr(p.getExpr());
            newList.add(new GbyVariableExpressionPair(p.getVar(), (Expression)be.second));
            changed |= ((Boolean)be.first).booleanValue();
        }
        return new Pair((Object)changed, newList);
    }

    protected Pair<Boolean, List<Pair<Expression, Identifier>>> inlineUdfsInFieldList(List<Pair<Expression, Identifier>> fieldList) throws CompilationException {
        ArrayList<Pair> newList = new ArrayList<Pair>(fieldList.size());
        boolean changed = false;
        for (Pair<Expression, Identifier> p : fieldList) {
            Pair<Boolean, Expression> be = this.inlineUdfsInExpr((Expression)p.first);
            newList.add(new Pair((Object)((Expression)be.second), (Object)((Identifier)p.second)));
            changed |= ((Boolean)be.first).booleanValue();
        }
        return new Pair((Object)changed, newList);
    }

    private Pair<Boolean, Map<Expression, VariableExpr>> inlineUdfsInVarMap(Map<Expression, VariableExpr> varMap) throws CompilationException {
        HashMap<Expression, VariableExpr> newMap = new HashMap<Expression, VariableExpr>();
        boolean changed = false;
        for (Map.Entry<Expression, VariableExpr> me : varMap.entrySet()) {
            Pair<Boolean, Expression> be = this.inlineUdfsInExpr(me.getKey());
            newMap.put((Expression)be.second, me.getValue());
            changed |= ((Boolean)be.first).booleanValue();
        }
        return new Pair((Object)changed, newMap);
    }
}

