/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.FDsAndEquivClassesVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class PhysicalOptimizationsUtil {
    public static void computeFDsAndEquivalenceClasses(ILogicalOperator op, IOptimizationContext ctx) throws AlgebricksException {
        FDsAndEquivClassesVisitor visitor = new FDsAndEquivClassesVisitor();
        PhysicalOptimizationsUtil.visitOperatorAndItsDescendants(op, visitor, ctx);
    }

    public static <R> void visitOperatorAndItsDescendants(ILogicalOperator op, ILogicalOperatorVisitor<R, IOptimizationContext> visitor, IOptimizationContext ctx) throws AlgebricksException {
        HashSet<ILogicalOperator> visitSet = new HashSet<ILogicalOperator>();
        PhysicalOptimizationsUtil.computeFDsAndEqClassesWithVisitorRec(op, ctx, visitor, visitSet);
    }

    private static <R> void computeFDsAndEqClassesWithVisitorRec(ILogicalOperator op, IOptimizationContext ctx, ILogicalOperatorVisitor<R, IOptimizationContext> visitor, Set<ILogicalOperator> visitSet) throws AlgebricksException {
        NestedTupleSourceOperator nts;
        ILogicalOperator source;
        visitSet.add(op);
        for (Object i : op.getInputs()) {
            PhysicalOptimizationsUtil.computeFDsAndEqClassesWithVisitorRec((ILogicalOperator)((AbstractLogicalOperator)i.getValue()), ctx, visitor, visitSet);
        }
        AbstractLogicalOperator aop = (AbstractLogicalOperator)op;
        if (aop.hasNestedPlans()) {
            for (ILogicalPlan p : ((AbstractOperatorWithNestedPlans)op).getNestedPlans()) {
                for (Mutable r : p.getRoots()) {
                    AbstractLogicalOperator rootOp = (AbstractLogicalOperator)r.getValue();
                    PhysicalOptimizationsUtil.computeFDsAndEqClassesWithVisitorRec((ILogicalOperator)rootOp, ctx, visitor, visitSet);
                }
            }
        }
        if (op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE && !visitSet.contains(source = (ILogicalOperator)((Mutable)((ILogicalOperator)(nts = (NestedTupleSourceOperator)op).getDataSourceReference().getValue()).getInputs().get(0)).getValue())) {
            PhysicalOptimizationsUtil.computeFDsAndEqClassesWithVisitorRec((ILogicalOperator)((AbstractLogicalOperator)source), ctx, visitor, visitSet);
        }
        op.accept(visitor, (Object)ctx);
    }
}

