/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.InMemUtils;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class APoint
implements IAObject {
    protected double x;
    protected double y;

    public APoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    @Override
    public IAType getType() {
        return BuiltinType.APOINT;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof APoint)) {
            return false;
        }
        APoint p = (APoint)obj;
        return this.x == p.x && this.y == p.y;
    }

    @Override
    public int hash() {
        return InMemUtils.hashDouble(this.x) + 31 * InMemUtils.hashDouble(this.y);
    }

    public String toString() {
        return "point: { x: " + this.x + ", y: " + this.y + " }";
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ObjectNode point = om.createObjectNode();
        point.put("x", this.x);
        point.put("y", this.y);
        json.set("APoint", (JsonNode)point);
        return json;
    }
}

