/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class DateWritable
implements WritableComparable<DateWritable> {
    private static final Log LOG = LogFactory.getLog(DateWritable.class);
    private static final long MILLIS_PER_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final ThreadLocal<TimeZone> LOCAL_TIMEZONE = new ThreadLocal<TimeZone>(){

        @Override
        protected TimeZone initialValue() {
            return Calendar.getInstance().getTimeZone();
        }
    };
    private int daysSinceEpoch = 0;

    public DateWritable() {
    }

    public DateWritable(DateWritable d) {
        this.set(d);
    }

    public DateWritable(Date d) {
        this.set(d);
    }

    public DateWritable(int d) {
        this.set(d);
    }

    public void set(int d) {
        this.daysSinceEpoch = d;
    }

    public void set(Date d) {
        if (d == null) {
            this.daysSinceEpoch = 0;
            return;
        }
        this.set(DateWritable.dateToDays(d));
    }

    public void set(DateWritable d) {
        this.set(d.daysSinceEpoch);
    }

    public Date get() {
        return new Date(DateWritable.daysToMillis(this.daysSinceEpoch));
    }

    public int getDays() {
        return this.daysSinceEpoch;
    }

    public long getTimeInSeconds() {
        return this.get().getTime() / 1000L;
    }

    public static Date timeToDate(long l) {
        return new Date(l * 1000L);
    }

    public static long daysToMillis(int d) {
        long millisUtc = (long)d * MILLIS_PER_DAY;
        return millisUtc - (long)LOCAL_TIMEZONE.get().getOffset(millisUtc);
    }

    public static int dateToDays(Date d) {
        long millisLocal = d.getTime();
        long millisUtc = millisLocal + (long)LOCAL_TIMEZONE.get().getOffset(millisLocal);
        return (int)(millisUtc / MILLIS_PER_DAY);
    }

    public void setFromBytes(byte[] bytes, int offset, int length, LazyBinaryUtils.VInt vInt) {
        LazyBinaryUtils.readVInt(bytes, offset, vInt);
        assert (length == vInt.length);
        this.set(vInt.value);
    }

    public void writeToByteStream(ByteStream.Output byteStream) {
        LazyBinaryUtils.writeVInt(byteStream, this.getDays());
    }

    public void readFields(DataInput in) throws IOException {
        this.daysSinceEpoch = WritableUtils.readVInt((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.daysSinceEpoch);
    }

    public int compareTo(DateWritable d) {
        return this.daysSinceEpoch - d.daysSinceEpoch;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateWritable)) {
            return false;
        }
        return this.compareTo((DateWritable)o) == 0;
    }

    public String toString() {
        return this.get().toString();
    }

    public int hashCode() {
        return this.daysSinceEpoch;
    }
}

