/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.context.FunctionExpressionMap;

public class FunctionSignatures {
    private final Map<FunctionSignature, FunctionExpressionMap> functionMap = new HashMap<FunctionSignature, FunctionExpressionMap>();

    public FunctionSignature get(DataverseName dataverseName, String name, int arity) {
        FunctionSignature fid = new FunctionSignature(dataverseName, name, arity);
        FunctionExpressionMap possibleFD = this.functionMap.get(fid);
        if (possibleFD == null) {
            return null;
        }
        return possibleFD.get(arity);
    }

    public void addAll(FunctionSignatures functionSignatures) {
        this.functionMap.putAll(functionSignatures.functionMap);
    }

    public void put(FunctionSignature fd, boolean varargs) {
        FunctionExpressionMap func = this.functionMap.get(fd);
        if (func == null) {
            func = new FunctionExpressionMap(varargs);
            this.functionMap.put(fd, func);
        }
        func.put(fd.getArity(), fd);
    }
}

