/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import io.netty.util.internal.PlatformDependent;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.ConcurrentMap;
import reactor.netty.Metrics;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.MeterKey;

public class MicrometerChannelMetricsRecorder
implements ChannelMetricsRecorder {
    final DistributionSummary.Builder dataReceivedBuilder;
    final ConcurrentMap<String, DistributionSummary> dataReceivedCache = PlatformDependent.newConcurrentHashMap();
    final DistributionSummary.Builder dataSentBuilder;
    final ConcurrentMap<String, DistributionSummary> dataSentCache = PlatformDependent.newConcurrentHashMap();
    final Counter.Builder errorCountBuilder;
    final ConcurrentMap<String, Counter> errorsCache = PlatformDependent.newConcurrentHashMap();
    final Timer.Builder connectTimeBuilder;
    final ConcurrentMap<MeterKey, Timer> connectTimeCache = PlatformDependent.newConcurrentHashMap();
    final Timer.Builder tlsHandshakeTimeBuilder;
    final ConcurrentMap<MeterKey, Timer> tlsHandshakeTimeCache = PlatformDependent.newConcurrentHashMap();
    final Timer.Builder addressResolverTimeBuilder;
    final ConcurrentMap<MeterKey, Timer> addressResolverTimeCache = PlatformDependent.newConcurrentHashMap();

    public MicrometerChannelMetricsRecorder(String name, String protocol) {
        this.dataReceivedBuilder = DistributionSummary.builder((String)(name + ".data.received")).baseUnit("bytes").description("Amount of the data that is received, in bytes").tag("uri", protocol);
        this.dataSentBuilder = DistributionSummary.builder((String)(name + ".data.sent")).baseUnit("bytes").description("Amount of the data that is sent, in bytes").tag("uri", protocol);
        this.errorCountBuilder = Counter.builder((String)(name + ".errors")).description("Number of the errors that are occurred").tag("uri", protocol);
        this.connectTimeBuilder = Timer.builder((String)(name + ".connect.time")).description("Time that is spent for connecting to the remote address");
        this.tlsHandshakeTimeBuilder = Timer.builder((String)(name + ".tls.handshake.time")).description("Time that is spent for TLS handshake");
        this.addressResolverTimeBuilder = Timer.builder((String)(name + ".address.resolver")).description("Time that is spent for resolving the address");
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        DistributionSummary ds = this.dataReceivedCache.computeIfAbsent(address, key -> this.dataReceivedBuilder.tag("remote.address", address).register(Metrics.REGISTRY));
        ds.record((double)bytes);
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        DistributionSummary ds = this.dataSentCache.computeIfAbsent(address, key -> this.dataSentBuilder.tag("remote.address", address).register(Metrics.REGISTRY));
        ds.record((double)bytes);
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Counter c = this.errorsCache.computeIfAbsent(address, key -> this.errorCountBuilder.tag("remote.address", address).register(Metrics.REGISTRY));
        c.increment();
    }

    @Override
    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer timer = this.tlsHandshakeTimeCache.computeIfAbsent(new MeterKey(null, address, null, status), key -> this.tlsHandshakeTimeBuilder.tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY));
        timer.record(time);
    }

    @Override
    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer timer = this.connectTimeCache.computeIfAbsent(new MeterKey(null, address, null, status), key -> this.connectTimeBuilder.tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY));
        timer.record(time);
    }

    @Override
    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer timer = this.addressResolverTimeCache.computeIfAbsent(new MeterKey(null, address, null, status), key -> this.addressResolverTimeBuilder.tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY));
        timer.record(time);
    }
}

