/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am.array;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;

public class ArrayIndexStructureMatcher
implements ArrayIndexUtil.TypeTrackerCommandExecutor {
    private final List<AbstractLogicalOperator> logicalOperators = new ArrayList<AbstractLogicalOperator>();
    private int lastMatchedPosition = -1;
    private boolean isStructureMatched = true;
    private LogicalVariable varFromParent;
    private IAType typeFromParent;

    public void executeActionOnEachArrayStep(ARecordType startingStepRecordType, IAType workingType, List<String> fieldName, boolean isFirstArrayStep, boolean isLastUnnestInIntermediateStep) {
        if (!this.isStructureMatched) {
            return;
        }
        boolean isStructureMatchedForThisStep = this.matchAssignVarAndFieldName(startingStepRecordType, fieldName);
        if (isStructureMatchedForThisStep) {
            isStructureMatchedForThisStep = this.matchUnnestVar();
        }
        this.isStructureMatched = this.isStructureMatched && isStructureMatchedForThisStep;
    }

    public void executeActionOnFinalArrayStep(ARecordType startingStepRecordType, List<String> fieldName, boolean isNonArrayStep, boolean requiresOnlyOneUnnest) {
        if (isNonArrayStep) {
            boolean bl = this.isStructureMatched = this.isStructureMatched && this.matchAssignVarAndFieldName(startingStepRecordType, fieldName);
        }
        if (!this.isStructureMatched) {
            this.varFromParent = null;
            this.lastMatchedPosition = -1;
        }
    }

    public void reset(LogicalVariable assignVar, OptimizableOperatorSubTree subTree) {
        this.varFromParent = assignVar;
        this.typeFromParent = null;
        this.isStructureMatched = true;
        this.lastMatchedPosition = -1;
        this.logicalOperators.clear();
        this.logicalOperators.addAll(subTree.getAssignsAndUnnests());
        Collections.reverse(this.logicalOperators);
    }

    public LogicalVariable getEndVar() {
        return this.varFromParent;
    }

    public ILogicalOperator getEndOperator() {
        return this.lastMatchedPosition == -1 ? null : (ILogicalOperator)this.logicalOperators.get(this.lastMatchedPosition);
    }

    private boolean matchUnnestVar() {
        boolean isStructureMatchedFoundForThisStep = false;
        for (int searchPosition = this.lastMatchedPosition + 1; !isStructureMatchedFoundForThisStep && searchPosition < this.logicalOperators.size(); ++searchPosition) {
            AbstractLogicalOperator workingOp = this.logicalOperators.get(searchPosition);
            if (!workingOp.getOperatorTag().equals((Object)LogicalOperatorTag.UNNEST)) continue;
            UnnestOperator workingOpAsUnnest = (UnnestOperator)workingOp;
            ArrayList expressionUsedVariables = new ArrayList();
            ILogicalExpression unnestExpr = (ILogicalExpression)workingOpAsUnnest.getExpressionRef().getValue();
            unnestExpr.getUsedVariables(expressionUsedVariables);
            if (!expressionUsedVariables.contains(this.varFromParent)) continue;
            this.varFromParent = workingOpAsUnnest.getVariable();
            this.lastMatchedPosition = searchPosition;
            isStructureMatchedFoundForThisStep = true;
        }
        return isStructureMatchedFoundForThisStep;
    }

    private boolean matchAssignVarAndFieldName(ARecordType recordType, List<String> fieldName) {
        boolean isStructureMatchedForThisStep = false;
        this.typeFromParent = recordType;
        for (String fieldPart : fieldName) {
            isStructureMatchedForThisStep = false;
            for (int searchPosition = this.lastMatchedPosition + 1; !isStructureMatchedForThisStep && searchPosition < this.logicalOperators.size(); ++searchPosition) {
                ARecordType typeForFieldPart;
                AbstractLogicalOperator workingOp = this.logicalOperators.get(searchPosition);
                if (!workingOp.getOperatorTag().equals((Object)LogicalOperatorTag.ASSIGN)) continue;
                ARecordType aRecordType = typeForFieldPart = this.typeFromParent instanceof ARecordType ? (ARecordType)this.typeFromParent : recordType;
                if (!this.matchAssignVarAndFieldPart((AssignOperator)workingOp, typeForFieldPart, fieldPart)) continue;
                isStructureMatchedForThisStep = true;
                this.lastMatchedPosition = searchPosition;
            }
        }
        return isStructureMatchedForThisStep;
    }

    private boolean matchAssignVarAndFieldPart(AssignOperator workingOp, ARecordType recordType, String fieldPart) {
        ArrayList expressionUsedVariables = new ArrayList();
        for (int j = 0; j < workingOp.getExpressions().size(); ++j) {
            ILogicalExpression assignExpr = (ILogicalExpression)((Mutable)workingOp.getExpressions().get(j)).getValue();
            assignExpr.getUsedVariables(expressionUsedVariables);
            boolean isVarInExpression = expressionUsedVariables.contains(this.varFromParent);
            boolean isVarInOutput = ((LogicalVariable)workingOp.getVariables().get(j)).equals((Object)this.varFromParent);
            if (!isVarInExpression && !isVarInOutput || !assignExpr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) continue;
            ScalarFunctionCallExpression assignFunc = (ScalarFunctionCallExpression)assignExpr;
            String fieldNameFromAssign = null;
            if (assignFunc.getFunctionIdentifier().equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_NAME)) {
                ConstantExpression assignNameExpr = (ConstantExpression)((Mutable)assignFunc.getArguments().get(1)).getValue();
                IAObject assignNameObj = ((AsterixConstantValue)assignNameExpr.getValue()).getObject();
                fieldNameFromAssign = ((AString)assignNameObj).getStringValue();
            } else if (assignFunc.getFunctionIdentifier().equals((Object)BuiltinFunctions.FIELD_ACCESS_BY_INDEX)) {
                ConstantExpression assignIndexExpr = (ConstantExpression)((Mutable)assignFunc.getArguments().get(1)).getValue();
                IAObject assignIndexObj = ((AsterixConstantValue)assignIndexExpr.getValue()).getObject();
                int assignIndex = ((AInt32)assignIndexObj).getIntegerValue();
                fieldNameFromAssign = recordType.getFieldNames()[assignIndex];
                this.typeFromParent = recordType.getFieldTypes()[assignIndex];
            }
            if (fieldNameFromAssign == null || !fieldNameFromAssign.equals(fieldPart)) continue;
            this.varFromParent = (LogicalVariable)workingOp.getVariables().get(j);
            return true;
        }
        return false;
    }
}

