/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.api.util.InvokeUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SingleThreadEventProcessor<T>
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final String name;
    private final LinkedBlockingQueue<T> eventInbox;
    private volatile Thread executorThread;
    private volatile boolean stopped = false;

    public SingleThreadEventProcessor(String threadName) {
        this.name = threadName;
        this.eventInbox = new LinkedBlockingQueue();
        this.executorThread = new Thread((Runnable)this, threadName);
        this.executorThread.start();
    }

    @Override
    public final void run() {
        LOGGER.log(Level.INFO, "Started " + Thread.currentThread().getName());
        while (!this.stopped) {
            try {
                T event = this.eventInbox.take();
                this.handle(event);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Error handling an event", (Throwable)e);
            }
        }
        LOGGER.log(Level.WARN, "Stopped " + Thread.currentThread().getName());
    }

    protected abstract void handle(T var1) throws Exception;

    public void add(T event) {
        if (!this.eventInbox.add(event)) {
            throw new IllegalStateException();
        }
    }

    public void stop() throws HyracksDataException {
        this.stopped = true;
        this.executorThread.interrupt();
        InvokeUtil.doUninterruptibly(() -> this.executorThread.join(1000L));
        int attempt = 0;
        while (this.executorThread.isAlive()) {
            LOGGER.log(Level.WARN, "Failed to stop event processor after {} attempts. Interrupted exception swallowed?", (Object)(++attempt), (Object)ExceptionUtils.fromThreadStack(this.executorThread));
            if (attempt == 10) {
                throw HyracksDataException.create(ErrorCode.FAILED_TO_SHUTDOWN_EVENT_PROCESSOR, new Serializable[]{this.name});
            }
            this.executorThread.interrupt();
            InvokeUtil.doUninterruptibly(() -> this.executorThread.join(1000L));
        }
    }
}

