/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluator;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluatorFactoryProvider;

public class PredicateEvaluatorFactoryProvider
implements IPredicateEvaluatorFactoryProvider {
    private static final long serialVersionUID = 1L;
    public static final PredicateEvaluatorFactoryProvider INSTANCE = new PredicateEvaluatorFactoryProvider();

    public IPredicateEvaluatorFactory getPredicateEvaluatorFactory(final int[] keys) {
        return new IPredicateEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IPredicateEvaluator createPredicateEvaluator() {
                return (fta, tupId) -> PredicateEvaluatorFactoryProvider.noNullOrMissingInKeys(fta, tupId, keys);
            }
        };
    }

    private static boolean noNullOrMissingInKeys(IFrameTupleAccessor fta, int tupId, int[] keys) {
        int tStart = fta.getTupleStartOffset(tupId);
        int fStartOffset = fta.getFieldSlotsLength() + tStart;
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            int fieldStartIx = fta.getFieldStartOffset(tupId, key);
            ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(fta.getBuffer().array()[fieldStartIx + fStartOffset]);
            if (typeTag != ATypeTag.MISSING && typeTag != ATypeTag.NULL) continue;
            return false;
        }
        return true;
    }
}

