/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern PARENT_DIR = Pattern.compile("([/\\\\]|^)[^./\\\\]+[/\\\\]\\.\\.([/\\\\]|$)");
    private static final Object LOCK = new Object();
    private static final int MAX_COPY_ATTEMPTS = 3;

    private FileUtil() {
    }

    public static String joinPath(String ... elements) {
        return FileUtil.joinPath(File.separatorChar, elements);
    }

    public static String joinPathUnix(String ... elements) {
        return FileUtil.joinPath('/', elements);
    }

    public static String joinPathWindows(String ... elements) {
        return FileUtil.joinPath('\\', elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceMkdirs(File dir) throws IOException {
        File canonicalDir = dir.getCanonicalFile();
        try {
            FileUtils.forceMkdir((File)canonicalDir);
        }
        catch (IOException e) {
            LOGGER.warn("failure to create directory {}, retrying", (Object)dir, (Object)e);
            Object object = LOCK;
            synchronized (object) {
                FileUtils.forceMkdir((File)canonicalDir);
            }
        }
    }

    static String joinPath(char separatorChar, String ... elements) {
        String separator = String.valueOf(separatorChar);
        String escapedSeparator = Pattern.quote(separator);
        String joined = String.join((CharSequence)separator, elements);
        if (separatorChar == '\\') {
            return joined.replaceAll("([^" + escapedSeparator + "])(" + escapedSeparator + ")+", "$1$2").replaceAll(escapedSeparator + "$", "");
        }
        return joined.replaceAll("(" + escapedSeparator + ")+", "$1").replaceAll(escapedSeparator + "$", "");
    }

    public static void safeCopyFile(File child, File destChild) throws IOException {
        FileUtil.forceMkdirs(destChild.getParentFile());
        IOException ioException = null;
        while (true) {
            try {
                FileUtils.copyFile((File)child, (File)destChild);
                return;
            }
            catch (IOException e) {
                if (ioException == null) {
                    ioException = e;
                    continue;
                }
                ioException.addSuppressed(e);
                if (ioException.getSuppressed().length < 3) continue;
                LOGGER.warn("Unable to copy {} to {} after 3 attempts; skipping file", (Object)child, (Object)destChild, (Object)e);
                return;
            }
            break;
        }
    }

    public static void writeAndForce(Path path, byte[] data) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "rw");){
            raf.write(data);
            raf.getChannel().force(true);
        }
    }

    public static String canonicalize(CharSequence path) {
        String newPath = path.toString();
        Matcher matcher = PARENT_DIR.matcher(newPath);
        while (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            matcher.appendReplacement(sb, matcher.group(2).isEmpty() ? "" : matcher.group(1).replace("\\", "\\\\"));
            matcher.appendTail(sb);
            newPath = sb.toString();
            matcher.reset(newPath);
        }
        return newPath;
    }

    public static File canonicalize(File file) {
        return new File(FileUtil.canonicalize(file.getPath()));
    }
}

