/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.scalar;

import java.util.List;
import org.apache.asterix.builders.AbvsBuilderFactory;
import org.apache.asterix.builders.ArrayListFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.aggregates.scalar.GenericScalarAggregateFunction;
import org.apache.asterix.runtime.aggregates.utils.PointableHashSet;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class GenericScalarDistinctAggregateFunction
extends GenericScalarAggregateFunction {
    private final IObjectPool<IMutableValueStorage, ATypeTag> storageAllocator = new ListObjectPool((IObjectFactory)new AbvsBuilderFactory());
    private final IObjectPool<List<IPointable>, ATypeTag> arrayListAllocator = new ListObjectPool((IObjectFactory)new ArrayListFactory());
    private final PointableHashSet itemSet;

    public GenericScalarDistinctAggregateFunction(IAggregateEvaluator aggFunc, IUnnestingEvaluatorFactory scanCollectionFactory, IEvaluatorContext context, SourceLocation sourceLoc, IAType itemType) throws HyracksDataException {
        super(aggFunc, scanCollectionFactory, context, sourceLoc);
        this.itemSet = new PointableHashSet(this.arrayListAllocator, itemType){

            @Override
            protected IPointable makeStoredItem(IPointable item) throws HyracksDataException {
                ArrayBackedValueStorage abvs = (ArrayBackedValueStorage)GenericScalarDistinctAggregateFunction.this.storageAllocator.allocate(null);
                abvs.assign((IValueReference)item);
                return abvs;
            }
        };
    }

    @Override
    protected void aggInit() throws HyracksDataException {
        super.aggInit();
        this.storageAllocator.reset();
        this.arrayListAllocator.reset();
        this.itemSet.clear();
    }

    @Override
    protected void aggStep(IPointable item) throws HyracksDataException {
        if (this.itemSet.add(item)) {
            super.aggStep(item);
        }
    }
}

