/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.util.Map;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.IndexStats;

public final class DatasetStreamStats {
    private final long cardinality;
    private final int avgTupleSize;
    private final Map<String, IndexStats> indexesStats;

    public DatasetStreamStats(IOperatorStats opStats) {
        this.cardinality = opStats.getTupleCounter().get();
        long totalTupleSize = opStats.getDiskIoCounter().get();
        this.avgTupleSize = this.cardinality > 0L ? (int)(totalTupleSize / this.cardinality) : 0;
        this.indexesStats = opStats.getIndexesStats();
    }

    static void update(IOperatorStats opStats, long tupleCount, long tupleSize, Map<String, IndexStats> indexStats) {
        opStats.getTupleCounter().update(tupleCount);
        opStats.getDiskIoCounter().update(tupleSize);
        opStats.updateIndexesStats(indexStats);
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public int getAvgTupleSize() {
        return this.avgTupleSize;
    }

    public Map<String, IndexStats> getIndexesStats() {
        return this.indexesStats;
    }
}

