/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.ITupleFilter;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.NoOpPageWriteCallback;

public class IndexBulkLoadOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    protected final IHyracksTaskContext ctx;
    protected final float fillFactor;
    protected final boolean verifyInput;
    protected final long numElementsHint;
    protected final boolean checkIfEmptyIndex;
    protected final IIndexDataflowHelper indexHelper;
    protected final RecordDescriptor recDesc;
    protected final PermutingFrameTupleReference tuple = new PermutingFrameTupleReference();
    protected final ITupleFilterFactory tupleFilterFactory;
    protected FrameTupleAccessor accessor;
    protected IIndex index;
    protected IIndexBulkLoader bulkLoader;
    protected ITupleFilter tupleFilter;
    protected FrameTupleReference frameTuple;

    public IndexBulkLoadOperatorNodePushable(IIndexDataflowHelperFactory indexDataflowHelperFactory, IHyracksTaskContext ctx, int partition, int[] fieldPermutation, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, RecordDescriptor recDesc, ITupleFilterFactory tupleFilterFactory) throws HyracksDataException {
        this.ctx = ctx;
        this.indexHelper = indexDataflowHelperFactory.create(ctx.getJobletContext().getServiceContext(), partition);
        this.fillFactor = fillFactor;
        this.verifyInput = verifyInput;
        this.numElementsHint = numElementsHint;
        this.checkIfEmptyIndex = checkIfEmptyIndex;
        this.recDesc = recDesc;
        this.tupleFilterFactory = tupleFilterFactory;
        this.tuple.setFieldPermutation(fieldPermutation);
    }

    public void open() throws HyracksDataException {
        this.accessor = new FrameTupleAccessor(this.recDesc);
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        try {
            this.writer.open();
            if (this.tupleFilterFactory != null) {
                this.tupleFilter = this.tupleFilterFactory.createTupleFilter(this.ctx);
                this.frameTuple = new FrameTupleReference();
            }
            this.initializeBulkLoader();
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            if (this.tupleFilter != null) {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
                if (!this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) continue;
            }
            this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
            this.bulkLoader.add((ITupleReference)this.tuple);
        }
        FrameUtils.flushFrame((ByteBuffer)buffer, (IFrameWriter)this.writer);
    }

    public void close() throws HyracksDataException {
        try {
            if (this.bulkLoader != null) {
                this.bulkLoader.end();
            }
        }
        catch (Throwable th) {
            throw HyracksDataException.create((Throwable)th);
        }
        finally {
            if (this.index != null) {
                try {
                    this.indexHelper.close();
                }
                finally {
                    this.writer.close();
                }
            }
        }
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }

    public void fail() throws HyracksDataException {
        if (this.index != null) {
            this.writer.fail();
        }
    }

    protected void initializeBulkLoader() throws HyracksDataException {
        this.bulkLoader = this.index.createBulkLoader(this.fillFactor, this.verifyInput, this.numElementsHint, this.checkIfEmptyIndex, (IPageWriteCallback)NoOpPageWriteCallback.INSTANCE);
    }
}

