/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.management;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.replication.IReplicationDestination;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.storage.DatasetResourceReference;
import org.apache.asterix.replication.api.ReplicationDestination;
import org.apache.asterix.replication.management.ReplicationOperation;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexReplicationJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexReplicationManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IReplicationManager replicationManager;
    private final Set<ReplicationDestination> destinations = ConcurrentHashMap.newKeySet();
    private final LinkedBlockingQueue<IReplicationJob> replicationJobsQ = new LinkedBlockingQueue();
    private final IReplicationStrategy replicationStrategy;
    private final PersistentLocalResourceRepository resourceRepository;
    private final INcApplicationContext appCtx;
    private final ILSMIOOperationScheduler ioScheduler;
    private final Object transferLock = new Object();
    private final Set<ReplicationDestination> failedDest = new HashSet<ReplicationDestination>();
    private final AtomicInteger pendingRepOpsCount = new AtomicInteger();

    public IndexReplicationManager(INcApplicationContext appCtx, IReplicationManager replicationManager) {
        this.appCtx = appCtx;
        this.replicationManager = replicationManager;
        this.resourceRepository = (PersistentLocalResourceRepository)appCtx.getLocalResourceRepository();
        this.replicationStrategy = replicationManager.getReplicationStrategy();
        appCtx.getThreadExecutor().execute(new ReplicationJobsProcessor());
        this.ioScheduler = appCtx.getStorageComponentProvider().getIoOperationSchedulerProvider().getIoScheduler(appCtx.getServiceContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ReplicationDestination dest) {
        Object object = this.transferLock;
        synchronized (object) {
            LOGGER.info(() -> "register " + dest);
            this.destinations.add(dest);
            this.failedDest.remove(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IReplicationDestination dest) {
        Object object = this.transferLock;
        synchronized (object) {
            LOGGER.info(() -> "unregister " + dest);
            for (ReplicationDestination existingDest : this.destinations) {
                if (!existingDest.equals(dest)) continue;
                existingDest.closeConnections();
                break;
            }
            this.destinations.remove(dest);
            this.failedDest.remove(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFailure(ReplicationDestination dest, Exception e) {
        Object object = this.transferLock;
        synchronized (object) {
            if (this.failedDest.contains(dest)) {
                return;
            }
            LOGGER.debug("Replica failed", (Throwable)e);
            if (this.destinations.contains(dest)) {
                LOGGER.error("replica at {} failed", (Object)dest);
                this.failedDest.add(dest);
            }
            dest.closeConnections();
            this.replicationManager.notifyFailure((IReplicationDestination)dest, e);
        }
    }

    public void accept(IReplicationJob job) {
        if (job.getExecutionType() == IReplicationJob.ReplicationExecutionType.ASYNC) {
            this.replicationJobsQ.add(job);
            return;
        }
        this.process(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReplicationDestination> getDestinations() {
        Object object = this.transferLock;
        synchronized (object) {
            return this.destinations;
        }
    }

    private void process(IReplicationJob job) {
        this.pendingRepOpsCount.incrementAndGet();
        Optional<DatasetResourceReference> jobIndexRefOpt = this.getJobIndexRef(job);
        if (jobIndexRefOpt.isEmpty()) {
            LOGGER.warn("skipping replication of {} due to missing dataset resource reference", (Object)job.getAnyFile());
            this.afterReplication(job);
            return;
        }
        ReplicationOperation rp = new ReplicationOperation(this.appCtx, jobIndexRefOpt.get(), job, this);
        if (job.getExecutionType() == IReplicationJob.ReplicationExecutionType.SYNC) {
            rp.call();
        } else {
            try {
                this.ioScheduler.scheduleOperation((ILSMIOOperation)rp);
            }
            catch (HyracksDataException e) {
                throw new ReplicationException((Throwable)e);
            }
        }
    }

    public boolean skip(DatasetResourceReference indexRef) {
        return !this.replicationStrategy.isMatch(indexRef.getDatasetId());
    }

    public Optional<DatasetResourceReference> getJobIndexRef(IReplicationJob job) {
        String fileToReplicate = job.getAnyFile();
        try {
            return this.resourceRepository.getLocalResourceReference(fileToReplicate);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException("Couldn't find resource for " + job.getAnyFile(), e);
        }
    }

    private void closeChannels() {
        LOGGER.trace("no pending replication jobs; closing connections to replicas");
        for (ReplicationDestination dest : this.destinations) {
            dest.closeConnections();
        }
    }

    public void afterReplication(IReplicationJob job) {
        try {
            int pendingOps = this.pendingRepOpsCount.decrementAndGet();
            if (job.getOperation() == IReplicationJob.ReplicationOperation.REPLICATE && job instanceof ILSMIndexReplicationJob) {
                ((ILSMIndexReplicationJob)job).endReplication();
            }
            if (pendingOps == 0 && this.replicationJobsQ.isEmpty()) {
                this.closeChannels();
            }
        }
        catch (HyracksDataException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    private class ReplicationJobsProcessor
    implements Runnable {
        private ReplicationJobsProcessor() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName(ReplicationJobsProcessor.class.getSimpleName());
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    IReplicationJob job = IndexReplicationManager.this.replicationJobsQ.take();
                    IndexReplicationManager.this.process(job);
                }
                catch (InterruptedException e) {
                    LOGGER.warn(() -> ReplicationJobsProcessor.class.getSimpleName() + " interrupted.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            LOGGER.warn("{} stopped.", (Object)ReplicationJobsProcessor.class.getSimpleName());
        }
    }
}

