/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.base;

import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.dataflow.ITimedWriter;
import org.apache.hyracks.api.dataflow.ProfiledFrameWriter;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.IOperatorStats;

public class ProfiledPushRuntime
extends ProfiledFrameWriter
implements IPushRuntime {
    private final IPushRuntime wrapped;
    private final IOperatorStats stats;
    private final boolean last;
    private final Map<Integer, ITimedWriter> outputs = new HashMap<Integer, ITimedWriter>();

    public ProfiledPushRuntime(IPushRuntime push, IOperatorStats stats, boolean last) {
        super((IFrameWriter)push);
        this.wrapped = push;
        this.stats = stats;
        this.last = last;
    }

    public void close() throws HyracksDataException {
        super.close();
        long ownTime = this.getTotalTime();
        if (!this.last) {
            this.stats.getTimeCounter().update(ownTime);
            return;
        }
        ownTime += this.stats.getTimeCounter().get();
        for (ITimedWriter w : this.outputs.values()) {
            ownTime -= w.getTotalTime();
        }
        this.stats.getTimeCounter().set(ownTime);
    }

    public IOperatorStats getStats() {
        return this.stats;
    }

    @Override
    public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
        if (writer instanceof ITimedWriter) {
            ITimedWriter wrapper = (ITimedWriter)writer;
            wrapper.setUpstreamStats(this.stats);
            this.outputs.put(index, wrapper);
        }
        this.wrapped.setOutputFrameWriter(index, writer, recordDesc);
    }

    @Override
    public void setInputRecordDescriptor(int index, RecordDescriptor recordDescriptor) {
        this.wrapped.setInputRecordDescriptor(index, recordDescriptor);
    }

    public static IPushRuntime time(IPushRuntime push, IOperatorStats stats, boolean last) throws HyracksDataException {
        if (!(push instanceof ProfiledPushRuntime)) {
            return new ProfiledPushRuntime(push, stats, last);
        }
        return push;
    }

    public static IPushRuntime time(IPushRuntime push, IOperatorStats stats) throws HyracksDataException {
        return ProfiledPushRuntime.time(push, stats, true);
    }
}

