/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.IIoOperationFailedCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SynchronousScheduler
implements ILSMIOOperationScheduler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, ILSMIOOperation> runningFlushOperations = new ConcurrentHashMap<String, ILSMIOOperation>();
    private final Map<String, Throwable> failedGroups = new ConcurrentHashMap<String, Throwable>();
    private final IIoOperationFailedCallback failureCallback;

    public SynchronousScheduler(IIoOperationFailedCallback failureCallback) {
        this.failureCallback = failureCallback;
    }

    @Override
    public void scheduleOperation(ILSMIOOperation operation) {
        try {
            this.before(operation);
            if (operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE) {
                return;
            }
            this.run(operation);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.after(operation);
        }
    }

    @Override
    public void completeOperation(ILSMIOOperation operation) throws HyracksDataException {
    }

    private void run(ILSMIOOperation operation) {
        try {
            operation.call();
        }
        catch (Throwable th) {
            LOGGER.log(Level.ERROR, "IO Operation failed", th);
            operation.setStatus(ILSMIOOperation.LSMIOOperationStatus.FAILURE);
            operation.setFailure(th);
        }
        if (operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE) {
            this.failureCallback.operationFailed(operation, operation.getFailure());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void after(ILSMIOOperation operation) {
        if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            Map<String, ILSMIOOperation> map = this.runningFlushOperations;
            synchronized (map) {
                this.runningFlushOperations.remove(operation.getIndexIdentifier());
                if (operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE) {
                    this.failedGroups.putIfAbsent(operation.getIndexIdentifier(), operation.getFailure());
                }
                operation.complete();
                this.runningFlushOperations.notifyAll();
            }
        } else {
            operation.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void before(ILSMIOOperation operation) throws InterruptedException {
        String id = operation.getIndexIdentifier();
        if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            Map<String, ILSMIOOperation> map = this.runningFlushOperations;
            synchronized (map) {
                while (true) {
                    if (this.failedGroups.containsKey(id)) {
                        operation.setStatus(ILSMIOOperation.LSMIOOperationStatus.FAILURE);
                        operation.setFailure(new RuntimeException("Operation group " + id + " has permanently failed", this.failedGroups.get(id)));
                        return;
                    }
                    if (!this.runningFlushOperations.containsKey(id)) break;
                    this.runningFlushOperations.wait();
                }
                this.runningFlushOperations.put(id, operation);
            }
        }
    }
}

