/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Strings;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.IIdentifierMapper;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.ITxnIdFactory;
import org.apache.asterix.common.transactions.TransactionOptions;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.formats.nontagged.CleanJSONPrinterFactoryProvider;
import org.apache.asterix.formats.nontagged.NullIntrospector;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.CachingTxnIdFactory;
import org.apache.asterix.metadata.api.ExtensionMetadataDataset;
import org.apache.asterix.metadata.api.ExtensionMetadataDatasetId;
import org.apache.asterix.metadata.api.IExtensionMetadataEntity;
import org.apache.asterix.metadata.api.IExtensionMetadataSearchKey;
import org.apache.asterix.metadata.api.IMetadataEntityTupleTranslator;
import org.apache.asterix.metadata.api.IMetadataExtension;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.api.IMetadataNode;
import org.apache.asterix.metadata.api.IValueExtractor;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.DependencyKind;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.metadata.entities.ViewDetails;
import org.apache.asterix.metadata.entitytupletranslators.CompactionPolicyTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatasetTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatasourceAdapterTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatatypeTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DataverseTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.ExternalFileTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedConnectionTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedPolicyTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FullTextConfigMetadataEntityTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FullTextFilterMetadataEntityTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FunctionTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.IndexTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.LibraryTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.MetadataTupleTranslatorProvider;
import org.apache.asterix.metadata.entitytupletranslators.NodeGroupTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.NodeTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.SynonymTupleTranslator;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.MetadataUtil;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.metadata.valueextractors.MetadataEntityValueExtractor;
import org.apache.asterix.metadata.valueextractors.TupleCopyValueExtractor;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.fulltext.FullTextConfigDescriptor;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.UpsertOperationCallback;
import org.apache.asterix.transaction.management.service.transaction.DatasetIdFactory;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.data.IPrinter;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.util.ExitUtil;
import org.apache.hyracks.util.JSONUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataNode
implements IMetadataNode {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private transient IDatasetLifecycleManager datasetLifecycleManager;
    private transient ITransactionSubsystem transactionSubsystem;
    private int metadataStoragePartition;
    private transient CachingTxnIdFactory txnIdFactory;
    private transient MetadataTupleTranslatorProvider tupleTranslatorProvider;
    private Map<ExtensionMetadataDatasetId, ExtensionMetadataDataset<?>> extensionDatasets;
    public static final MetadataNode INSTANCE = new MetadataNode();

    private MetadataNode() {
    }

    public void initialize(INcApplicationContext runtimeContext, MetadataTupleTranslatorProvider tupleTranslatorProvider, List<IMetadataExtension> metadataExtensions, int partitionId) {
        this.tupleTranslatorProvider = tupleTranslatorProvider;
        this.transactionSubsystem = runtimeContext.getTransactionSubsystem();
        this.datasetLifecycleManager = runtimeContext.getDatasetLifecycleManager();
        this.metadataStoragePartition = partitionId;
        if (metadataExtensions != null) {
            this.extensionDatasets = new HashMap();
            for (IMetadataExtension metadataExtension : metadataExtensions) {
                for (ExtensionMetadataDataset extensionIndex : metadataExtension.getExtensionIndexes()) {
                    this.extensionDatasets.put(extensionIndex.getId(), extensionIndex);
                }
            }
        }
        this.txnIdFactory = new CachingTxnIdFactory(runtimeContext);
    }

    public int getMetadataStoragePartition() {
        return this.metadataStoragePartition;
    }

    @Override
    public void beginTransaction(TxnId transactionId) {
        TransactionOptions options = new TransactionOptions(ITransactionManager.AtomicityLevel.ATOMIC);
        this.transactionSubsystem.getTransactionManager().beginTransaction(transactionId, options);
    }

    @Override
    public void commitTransaction(TxnId txnId) {
        try {
            this.transactionSubsystem.getTransactionManager().commitTransaction(txnId);
        }
        catch (Throwable th) {
            LOGGER.fatal("Failure committing a metadata transaction", th);
            ExitUtil.halt((int)6);
        }
    }

    @Override
    public void abortTransaction(TxnId txnId) {
        try {
            this.transactionSubsystem.getTransactionManager().abortTransaction(txnId);
        }
        catch (Throwable th) {
            LOGGER.fatal("Failure committing a metadata transaction", th);
            ExitUtil.halt((int)7);
        }
    }

    private <T> void addEntity(TxnId txnId, T entity, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws AlgebricksException {
        try {
            ITupleReference tuple = tupleTranslator.getTupleFromMetadataEntity(entity);
            this.insertTupleIntoIndex(txnId, index, tuple);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private <T> void upsertEntity(TxnId txnId, T entity, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws AlgebricksException {
        try {
            ITupleReference tuple = tupleTranslator.getTupleFromMetadataEntity(entity);
            this.upsertTupleIntoIndex(txnId, index, tuple);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private <T> void deleteEntity(TxnId txnId, T entity, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws AlgebricksException {
        try {
            ITupleReference tuple = tupleTranslator.getTupleFromMetadataEntity(entity);
            this.deleteTupleFromIndex(txnId, index, tuple);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private <T> List<T> getEntities(TxnId txnId, ITupleReference searchKey, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws AlgebricksException {
        try {
            MetadataEntityValueExtractor<T> valueExtractor = new MetadataEntityValueExtractor<T>(tupleTranslator);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, index, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> void addEntity(TxnId txnId, T entity) throws AlgebricksException {
        ExtensionMetadataDataset<T> index = this.getExtensionMetadataDataset(entity.getDatasetId());
        IMetadataEntityTupleTranslator<T> tupleTranslator = index.getTupleTranslator(true);
        this.addEntity(txnId, entity, tupleTranslator, index);
    }

    @Override
    public <T extends IExtensionMetadataEntity> void upsertEntity(TxnId txnId, T entity) throws AlgebricksException {
        ExtensionMetadataDataset<T> index = this.getExtensionMetadataDataset(entity.getDatasetId());
        IMetadataEntityTupleTranslator<T> tupleTranslator = index.getTupleTranslator(true);
        this.upsertEntity(txnId, entity, tupleTranslator, index);
    }

    @Override
    public <T extends IExtensionMetadataEntity> void deleteEntity(TxnId txnId, T entity) throws AlgebricksException {
        ExtensionMetadataDataset<T> index = this.getExtensionMetadataDataset(entity.getDatasetId());
        IMetadataEntityTupleTranslator<T> tupleTranslator = index.getTupleTranslator(true);
        this.deleteEntity(txnId, entity, tupleTranslator, index);
    }

    @Override
    public <T extends IExtensionMetadataEntity> List<T> getEntities(TxnId txnId, IExtensionMetadataSearchKey searchKey) throws AlgebricksException {
        ExtensionMetadataDataset<T> index = this.getExtensionMetadataDataset(searchKey.getDatasetId());
        IMetadataEntityTupleTranslator<T> tupleTranslator = index.getTupleTranslator(false);
        return this.getEntities(txnId, searchKey.getSearchKey(), tupleTranslator, index);
    }

    @Override
    public JsonNode getEntitiesAsJson(TxnId txnId, IMetadataIndex metadataIndex, int payloadPosition) throws AlgebricksException, RemoteException {
        try {
            return this.getJsonNodes(txnId, metadataIndex, payloadPosition);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private <T extends IExtensionMetadataEntity> ExtensionMetadataDataset<T> getExtensionMetadataDataset(ExtensionMetadataDatasetId datasetId) throws AlgebricksException {
        ExtensionMetadataDataset<?> index = this.extensionDatasets.get(datasetId);
        if (index == null) {
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.METADATA_ERROR, new Serializable[]{"Metadata Extension Index: " + datasetId + " was not found"});
        }
        return index;
    }

    @Override
    public void addDataverse(TxnId txnId, Dataverse dataverse) throws AlgebricksException {
        try {
            DataverseTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataverseTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(dataverse);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.DATAVERSE_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.DATAVERSE_EXISTS, (Throwable)e, new Serializable[]{dataverse.getDataverseName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addDataset(TxnId txnId, Dataset dataset) throws AlgebricksException {
        try {
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(true);
            ITupleReference datasetTuple = tupleReaderWriter.getTupleFromMetadataEntity(dataset);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                InternalDatasetDetails id = (InternalDatasetDetails)dataset.getDatasetDetails();
                Index primaryIndex = Index.createPrimaryIndex(dataset.getDataverseName(), dataset.getDatasetName(), id.getPrimaryKey(), id.getKeySourceIndicator(), id.getPrimaryKeyType(), dataset.getPendingOp());
                this.addIndex(txnId, primaryIndex);
            }
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.DATASET_EXISTS, (Throwable)e, new Serializable[]{dataset.getDatasetName(), dataset.getDataverseName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addIndex(TxnId txnId, Index index) throws AlgebricksException {
        try {
            IndexTupleTranslator tupleWriter = this.tupleTranslatorProvider.getIndexTupleTranslator(txnId, this, true);
            ITupleReference tuple = tupleWriter.getTupleFromMetadataEntity(index);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.INDEX_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.INDEX_EXISTS, (Throwable)e, new Serializable[]{index.getIndexName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addNode(TxnId txnId, Node node) throws AlgebricksException {
        try {
            NodeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getNodeTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(node);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.NODE_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.NODE_EXISTS, (Throwable)e, new Serializable[]{node.getNodeName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void modifyNodeGroup(TxnId txnId, NodeGroup nodeGroup, AbstractIndexModificationOperationCallback.Operation modificationOp) throws AlgebricksException {
        try {
            NodeGroupTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getNodeGroupTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(nodeGroup);
            this.modifyMetadataIndex(modificationOp, txnId, MetadataPrimaryIndexes.NODEGROUP_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.NODEGROUP_EXISTS, (Throwable)e, new Serializable[]{nodeGroup.getNodeGroupName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addDatatype(TxnId txnId, Datatype datatype) throws AlgebricksException {
        try {
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(txnId, this, true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(datatype);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.TYPE_EXISTS, (Throwable)e, new Serializable[]{datatype.getDatatypeName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addFunction(TxnId txnId, Function function) throws AlgebricksException {
        try {
            FunctionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFunctionTupleTranslator(txnId, this, true);
            ITupleReference functionTuple = tupleReaderWriter.getTupleFromMetadataEntity(function);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, functionTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.FUNCTION_EXISTS, (Throwable)e, new Serializable[]{function.getName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addFullTextFilter(TxnId txnId, FullTextFilterMetadataEntity filterMetadataEntity) throws RemoteException, AlgebricksException {
        this.insertFullTextFilterMetadataEntityToCatalog(txnId, filterMetadataEntity);
    }

    @Override
    public FullTextFilterMetadataEntity getFullTextFilter(TxnId txnId, DataverseName dataverseName, String filterName) throws AlgebricksException {
        try {
            FullTextFilterMetadataEntityTupleTranslator translator = this.tupleTranslatorProvider.getFullTextFilterTupleTranslator(true);
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName.getCanonicalForm(), filterName);
            MetadataEntityValueExtractor<FullTextFilterMetadataEntity> valueExtractor = new MetadataEntityValueExtractor<FullTextFilterMetadataEntity>(translator);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.FULL_TEXT_FILTER_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (FullTextFilterMetadataEntity)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropFullTextFilter(TxnId txnId, DataverseName dataverseName, String filterName) throws AlgebricksException {
        this.dropFullTextFilterDescriptor(txnId, dataverseName, filterName, false);
    }

    private void dropFullTextFilterDescriptor(TxnId txnId, DataverseName dataverseName, String filterName, boolean force) throws AlgebricksException {
        if (!force) {
            this.confirmFullTextFilterCanBeDeleted(txnId, dataverseName, filterName);
        }
        try {
            FullTextFilterMetadataEntityTupleTranslator translator = this.tupleTranslatorProvider.getFullTextFilterTupleTranslator(true);
            ITupleReference key = MetadataNode.createTuple(dataverseName.getCanonicalForm(), filterName);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.FULL_TEXT_FILTER_DATASET, key);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void insertFullTextConfigMetadataEntityToCatalog(TxnId txnId, FullTextConfigMetadataEntity config) throws AlgebricksException {
        try {
            FullTextConfigMetadataEntityTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFullTextConfigTupleTranslator(true);
            ITupleReference configTuple = tupleReaderWriter.getTupleFromMetadataEntity(config);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.FULL_TEXT_CONFIG_DATASET, configTuple);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void insertFullTextFilterMetadataEntityToCatalog(TxnId txnId, FullTextFilterMetadataEntity filter) throws AlgebricksException {
        try {
            FullTextFilterMetadataEntityTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFullTextFilterTupleTranslator(true);
            ITupleReference filterTuple = tupleReaderWriter.getTupleFromMetadataEntity(filter);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.FULL_TEXT_FILTER_DATASET, filterTuple);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addFullTextConfig(TxnId txnId, FullTextConfigMetadataEntity config) throws AlgebricksException, RemoteException {
        try {
            this.insertFullTextConfigMetadataEntityToCatalog(txnId, config);
        }
        catch (AlgebricksException e) {
            throw new AlgebricksException((Throwable)e, ErrorCode.ERROR_PROCESSING_TUPLE, new Serializable[0]);
        }
    }

    @Override
    public FullTextConfigMetadataEntity getFullTextConfig(TxnId txnId, DataverseName dataverseName, String configName) throws AlgebricksException {
        FullTextConfigMetadataEntityTupleTranslator translator = this.tupleTranslatorProvider.getFullTextConfigTupleTranslator(true);
        ArrayList results = new ArrayList();
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName.getCanonicalForm(), configName);
            MetadataEntityValueExtractor<FullTextConfigMetadataEntity> valueExtractor = new MetadataEntityValueExtractor<FullTextConfigMetadataEntity>(translator);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FULL_TEXT_CONFIG_DATASET, searchKey, valueExtractor, results);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        if (results.isEmpty()) {
            return null;
        }
        FullTextConfigMetadataEntity result = (FullTextConfigMetadataEntity)results.get(0);
        return result;
    }

    @Override
    public void dropFullTextConfig(TxnId txnId, DataverseName dataverseName, String configName) throws AlgebricksException {
        this.dropFullTextConfigDescriptor(txnId, dataverseName, configName, false);
    }

    private void dropFullTextConfigDescriptor(TxnId txnId, DataverseName dataverseName, String configName, boolean force) throws AlgebricksException {
        if (!force) {
            this.confirmFullTextConfigCanBeDeleted(txnId, dataverseName, configName);
        }
        try {
            ITupleReference key = MetadataNode.createTuple(dataverseName.getCanonicalForm(), configName);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.FULL_TEXT_CONFIG_DATASET, key);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void insertTupleIntoIndex(TxnId txnId, IMetadataIndex metadataIndex, ITupleReference tuple) throws HyracksDataException {
        this.modifyMetadataIndex(AbstractIndexModificationOperationCallback.Operation.INSERT, txnId, metadataIndex, tuple);
    }

    private void upsertTupleIntoIndex(TxnId txnId, IMetadataIndex metadataIndex, ITupleReference tuple) throws HyracksDataException {
        this.modifyMetadataIndex(AbstractIndexModificationOperationCallback.Operation.UPSERT, txnId, metadataIndex, tuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void modifyMetadataIndex(AbstractIndexModificationOperationCallback.Operation op, TxnId txnId, IMetadataIndex metadataIndex, ITupleReference tuple) throws HyracksDataException {
        String resourceName = metadataIndex.getFile().getRelativePath();
        ILSMIndex lsmIndex = (ILSMIndex)this.datasetLifecycleManager.get(resourceName);
        this.datasetLifecycleManager.open(resourceName);
        try {
            ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(txnId);
            IModificationOperationCallback modCallback = this.createIndexModificationCallback(op, txnCtx, metadataIndex);
            IndexAccessParameters iap = new IndexAccessParameters(modCallback, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            ILSMIndexAccessor indexAccessor = lsmIndex.createAccessor((IIndexAccessParameters)iap);
            txnCtx.setWriteTxn(true);
            txnCtx.register(metadataIndex.getResourceId(), StoragePathUtil.getPartitionNumFromRelativePath((String)resourceName), lsmIndex, modCallback, metadataIndex.isPrimaryIndex());
            LSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)lsmIndex), (ILogManager)this.transactionSubsystem.getLogManager());
            switch (op) {
                case INSERT: {
                    indexAccessor.forceInsert(tuple);
                    return;
                }
                case DELETE: {
                    indexAccessor.forceDelete(tuple);
                    return;
                }
                case UPSERT: {
                    indexAccessor.forceUpsert(tuple);
                    return;
                }
                default: {
                    throw new IllegalStateException("Unknown operation type: " + op);
                }
            }
        }
        finally {
            this.datasetLifecycleManager.close(resourceName);
        }
    }

    private IModificationOperationCallback createIndexModificationCallback(AbstractIndexModificationOperationCallback.Operation indexOp, ITransactionContext txnCtx, IMetadataIndex metadataIndex) {
        switch (indexOp) {
            case INSERT: 
            case DELETE: {
                return new SecondaryIndexModificationOperationCallback(metadataIndex.getDatasetId(), metadataIndex.getPrimaryKeyIndexes(), txnCtx, this.transactionSubsystem.getLockManager(), this.transactionSubsystem, metadataIndex.getResourceId(), this.metadataStoragePartition, 0, indexOp);
            }
            case UPSERT: {
                return new UpsertOperationCallback(metadataIndex.getDatasetId(), metadataIndex.getPrimaryKeyIndexes(), txnCtx, this.transactionSubsystem.getLockManager(), this.transactionSubsystem, metadataIndex.getResourceId(), this.metadataStoragePartition, 0, indexOp);
            }
        }
        throw new IllegalStateException("Unknown operation type: " + indexOp);
    }

    @Override
    public void dropDataverse(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        try {
            this.confirmDataverseCanBeDeleted(txnId, dataverseName);
            List<Feed> dataverseFeeds = this.getDataverseFeeds(txnId, dataverseName);
            for (Feed feed : dataverseFeeds) {
                List<FeedConnection> list = this.getFeedConnections(txnId, dataverseName, feed.getFeedName());
                for (FeedConnection feedConnection : list) {
                    this.dropFeedConnection(txnId, dataverseName, feed.getFeedName(), feedConnection.getDatasetName());
                }
                this.dropFeed(txnId, dataverseName, feed.getFeedName());
            }
            List<FeedPolicyEntity> feedPolicies = this.getDataverseFeedPolicies(txnId, dataverseName);
            for (FeedPolicyEntity feedPolicyEntity : feedPolicies) {
                this.dropFeedPolicy(txnId, dataverseName, feedPolicyEntity.getPolicyName());
            }
            List<Function> list = this.getDataverseFunctions(txnId, dataverseName);
            for (Function function : list) {
                this.dropFunction(txnId, function.getSignature(), true);
            }
            List<DatasourceAdapter> list2 = this.getDataverseAdapters(txnId, dataverseName);
            for (DatasourceAdapter datasourceAdapter : list2) {
                this.dropAdapter(txnId, dataverseName, datasourceAdapter.getAdapterIdentifier().getName());
            }
            List<Library> list3 = this.getDataverseLibraries(txnId, dataverseName);
            for (Library library : list3) {
                this.dropLibrary(txnId, library.getDataverseName(), library.getName());
            }
            List<Synonym> list4 = this.getDataverseSynonyms(txnId, dataverseName);
            for (Synonym synonym : list4) {
                this.dropSynonym(txnId, dataverseName, synonym.getSynonymName(), true);
            }
            List<Dataset> list5 = this.getDataverseDatasets(txnId, dataverseName);
            for (Dataset dataset : list5) {
                this.dropDataset(txnId, dataverseName, dataset.getDatasetName(), true);
            }
            List<FullTextConfigMetadataEntity> list6 = this.getDataverseFullTextConfigs(txnId, dataverseName);
            for (FullTextConfigMetadataEntity fullTextConfigMetadataEntity : list6) {
                this.dropFullTextConfigDescriptor(txnId, dataverseName, fullTextConfigMetadataEntity.getFullTextConfig().getName(), true);
            }
            List<FullTextFilterMetadataEntity> list7 = this.getDataverseFullTextFilters(txnId, dataverseName);
            for (FullTextFilterMetadataEntity fullTextFilterMetadataEntity : list7) {
                this.dropFullTextFilterDescriptor(txnId, dataverseName, fullTextFilterMetadataEntity.getFullTextFilter().getName(), true);
            }
            List<Datatype> list8 = this.getDataverseDatatypes(txnId, dataverseName);
            for (Datatype dataverseDatatype : list8) {
                this.forceDropDatatype(txnId, dataverseName, dataverseDatatype.getDatatypeName());
            }
            ITupleReference iTupleReference = MetadataNode.createTuple(dataverseName, new String[0]);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATAVERSE_DATASET, iTupleReference);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATAVERSE_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_DATAVERSE, (Throwable)e, new Serializable[]{dataverseName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public boolean isDataverseNotEmpty(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        return !this.getDataverseDatatypes(txnId, dataverseName).isEmpty() || !this.getDataverseDatasets(txnId, dataverseName).isEmpty() || !this.getDataverseLibraries(txnId, dataverseName).isEmpty() || !this.getDataverseAdapters(txnId, dataverseName).isEmpty() || !this.getDataverseFunctions(txnId, dataverseName).isEmpty() || !this.getDataverseFeedPolicies(txnId, dataverseName).isEmpty() || !this.getDataverseFeeds(txnId, dataverseName).isEmpty() || !this.getDataverseSynonyms(txnId, dataverseName).isEmpty() || !this.getDataverseFullTextConfigs(txnId, dataverseName).isEmpty() || !this.getDataverseFullTextFilters(txnId, dataverseName).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dropDataset(TxnId txnId, DataverseName dataverseName, String datasetName, boolean force) throws AlgebricksException {
        Dataset dataset = this.getDataset(txnId, dataverseName, datasetName);
        if (dataset == null) {
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, new Serializable[]{datasetName, dataverseName});
        }
        if (!force) {
            String datasetTypeDisplayName = DatasetUtil.getDatasetTypeDisplayName(dataset.getDatasetType());
            this.confirmDatasetCanBeDeleted(txnId, datasetTypeDisplayName, dataverseName, datasetName);
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName);
            ITupleReference datasetTuple = null;
            try {
                datasetTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey);
                switch (dataset.getDatasetType()) {
                    case INTERNAL: {
                        List<Index> datasetIndexes = this.getDatasetIndexes(txnId, dataverseName, datasetName);
                        if (datasetIndexes == null) return;
                        Iterator<Index> iterator = datasetIndexes.iterator();
                        while (iterator.hasNext()) {
                            Index index = iterator.next();
                            this.dropIndex(txnId, dataverseName, datasetName, index.getIndexName());
                        }
                        return;
                    }
                    case EXTERNAL: {
                        List<ExternalFile> datasetFiles;
                        List<Index> datasetIndexes = this.getDatasetIndexes(txnId, dataverseName, datasetName);
                        if (datasetIndexes != null) {
                            for (Index index : datasetIndexes) {
                                this.dropIndex(txnId, dataverseName, datasetName, index.getIndexName());
                            }
                        }
                        if ((datasetFiles = this.getExternalFiles(txnId, dataset)) == null) return;
                        if (datasetFiles.isEmpty()) return;
                        Iterator<ExternalFile> iterator = datasetFiles.iterator();
                        while (iterator.hasNext()) {
                            ExternalFile file = iterator.next();
                            this.dropExternalFile(txnId, dataverseName, file.getDatasetName(), file.getFileNumber());
                        }
                        return;
                    }
                }
                return;
            }
            catch (HyracksDataException hde) {
                if (hde.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) return;
                throw new AlgebricksException((Throwable)hde);
            }
            finally {
                this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            }
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropIndex(TxnId txnId, DataverseName dataverseName, String datasetName, String indexName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName, indexName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.INDEX_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_INDEX, (Throwable)e, new Serializable[]{indexName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public boolean dropNodegroup(TxnId txnId, String nodeGroupName, boolean failSilently) throws AlgebricksException {
        List<Dataset> datasets = this.getDatasetsPartitionedOnThisNodeGroup(txnId, nodeGroupName);
        if (!datasets.isEmpty()) {
            if (failSilently) {
                return false;
            }
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_OBJECT_DEPENDENT_EXISTS, new Serializable[]{"node group", nodeGroupName, IdentifierUtil.dataset((IIdentifierMapper.Modifier)IIdentifierMapper.Modifier.PLURAL), (Serializable)((Object)datasets.stream().map(DatasetUtil::getFullyQualifiedDisplayName).collect(Collectors.joining(", ")))});
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(nodeGroupName, new String[0]);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.NODEGROUP_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.NODEGROUP_DATASET, tuple);
            return true;
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_NODEGROUP, (Throwable)e, new Serializable[]{nodeGroupName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropDatatype(TxnId txnId, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        this.dropDatatype(txnId, dataverseName, datatypeName, false);
    }

    private void dropDatatype(TxnId txnId, DataverseName dataverseName, String datatypeName, boolean force) throws AlgebricksException {
        if (!force) {
            this.confirmDatatypeIsUnused(txnId, dataverseName, datatypeName);
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datatypeName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey);
            List<String> nestedTypes = this.getNestedComplexDatatypeNamesForThisDatatype(txnId, dataverseName, datatypeName);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
            for (String nestedType : nestedTypes) {
                Datatype dt = this.getDatatype(txnId, dataverseName, nestedType);
                if (dt == null || !dt.getIsAnonymous()) continue;
                this.dropDatatype(txnId, dataverseName, dt.getDatatypeName());
            }
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_TYPE, (Throwable)e, new Serializable[]{datatypeName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void forceDropDatatype(TxnId txnId, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datatypeName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_TYPE, (Throwable)e, new Serializable[]{datatypeName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void deleteTupleFromIndex(TxnId txnId, IMetadataIndex metadataIndex, ITupleReference tuple) throws HyracksDataException {
        this.modifyMetadataIndex(AbstractIndexModificationOperationCallback.Operation.DELETE, txnId, metadataIndex, tuple);
    }

    @Override
    public List<Dataverse> getDataverses(TxnId txnId) throws AlgebricksException {
        try {
            DataverseTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataverseTupleTranslator(false);
            MetadataEntityValueExtractor<Dataverse> valueExtractor = new MetadataEntityValueExtractor<Dataverse>(tupleReaderWriter);
            ArrayList<Dataverse> results = new ArrayList<Dataverse>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATAVERSE_DATASET, null, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Dataverse getDataverse(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
            DataverseTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataverseTupleTranslator(false);
            MetadataEntityValueExtractor<Dataverse> valueExtractor = new MetadataEntityValueExtractor<Dataverse>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATAVERSE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Dataverse)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Dataset> getDataverseDatasets(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            ArrayList<Dataset> results = new ArrayList<Dataset>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Feed> getDataverseFeeds(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(false);
            MetadataEntityValueExtractor<Feed> valueExtractor = new MetadataEntityValueExtractor<Feed>(tupleReaderWriter);
            ArrayList<Feed> results = new ArrayList<Feed>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Library> getDataverseLibraries(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
            LibraryTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getLibraryTupleTranslator(false);
            MetadataEntityValueExtractor<Library> valueExtractor = new MetadataEntityValueExtractor<Library>(tupleReaderWriter);
            ArrayList<Library> results = new ArrayList<Library>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private List<Datatype> getDataverseDatatypes(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(txnId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList<Datatype> results = new ArrayList<Datatype>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private List<FullTextConfigMetadataEntity> getDataverseFullTextConfigs(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
        FullTextConfigMetadataEntityTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFullTextConfigTupleTranslator(true);
        MetadataEntityValueExtractor<FullTextConfigMetadataEntity> valueExtractor = new MetadataEntityValueExtractor<FullTextConfigMetadataEntity>(tupleReaderWriter);
        ArrayList<FullTextConfigMetadataEntity> results = new ArrayList<FullTextConfigMetadataEntity>();
        try {
            this.searchIndex(txnId, MetadataPrimaryIndexes.FULL_TEXT_CONFIG_DATASET, searchKey, valueExtractor, results);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return results;
    }

    private List<FullTextFilterMetadataEntity> getDataverseFullTextFilters(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
        FullTextFilterMetadataEntityTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFullTextFilterTupleTranslator(true);
        MetadataEntityValueExtractor<FullTextFilterMetadataEntity> valueExtractor = new MetadataEntityValueExtractor<FullTextFilterMetadataEntity>(tupleReaderWriter);
        ArrayList<FullTextFilterMetadataEntity> results = new ArrayList<FullTextFilterMetadataEntity>();
        try {
            this.searchIndex(txnId, MetadataPrimaryIndexes.FULL_TEXT_FILTER_DATASET, searchKey, valueExtractor, results);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return results;
    }

    @Override
    public Dataset getDataset(TxnId txnId, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName);
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Dataset)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public List<Dataset> getAllDatasets(TxnId txnId) throws AlgebricksException {
        try {
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            ArrayList<Dataset> results = new ArrayList<Dataset>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, null, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public List<Function> getAllFunctions(TxnId txnId) throws AlgebricksException {
        return this.getFunctionsImpl(txnId, null);
    }

    public List<Datatype> getAllDatatypes(TxnId txnId) throws AlgebricksException {
        try {
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(txnId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList<Datatype> results = new ArrayList<Datatype>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, null, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public List<DatasourceAdapter> getAllAdapters(TxnId txnId) throws AlgebricksException {
        try {
            DatasourceAdapterTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getAdapterTupleTranslator(false);
            ArrayList<DatasourceAdapter> results = new ArrayList<DatasourceAdapter>();
            MetadataEntityValueExtractor<DatasourceAdapter> valueExtractor = new MetadataEntityValueExtractor<DatasourceAdapter>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, null, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public List<FeedConnection> getAllFeedConnections(TxnId txnId) throws AlgebricksException {
        try {
            FeedConnectionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedConnectionTupleTranslator(false);
            ArrayList<FeedConnection> results = new ArrayList<FeedConnection>();
            MetadataEntityValueExtractor<FeedConnection> valueExtractor = new MetadataEntityValueExtractor<FeedConnection>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, null, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void confirmDataverseCanBeDeleted(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        int i;
        int n;
        List<List<Triple<DataverseName, String, String>>> dependencies;
        List<DependencyKind> dependenciesSchema;
        List<Dataset> datasets = this.getAllDatasets(txnId);
        for (Dataset dataset : datasets) {
            if (dataset.getDataverseName().equals((Object)dataverseName)) continue;
            if (dataset.getItemTypeDataverseName().equals((Object)dataverseName)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_DATAVERSE_DEPENDENT_EXISTS, new Serializable[]{"type", TypeUtil.getFullyQualifiedDisplayName(dataset.getItemTypeDataverseName(), dataset.getItemTypeName()), IdentifierUtil.dataset(), DatasetUtil.getFullyQualifiedDisplayName(dataset)});
            }
            if (dataset.hasMetaPart() && dataset.getMetaItemTypeDataverseName().equals((Object)dataverseName)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_DATAVERSE_DEPENDENT_EXISTS, new Serializable[]{"type", TypeUtil.getFullyQualifiedDisplayName(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName()), IdentifierUtil.dataset(), DatasetUtil.getFullyQualifiedDisplayName(dataset)});
            }
            if (dataset.getDatasetType() != DatasetConfig.DatasetType.VIEW) continue;
            ViewDetails viewDetails = (ViewDetails)dataset.getDatasetDetails();
            dependenciesSchema = ViewDetails.DEPENDENCIES_SCHEMA;
            dependencies = viewDetails.getDependencies();
            n = dependencies.size();
            for (i = 0; i < n; ++i) {
                for (Triple<DataverseName, String, String> dependency : dependencies.get(i)) {
                    if (!((DataverseName)dependency.first).equals((Object)dataverseName)) continue;
                    DependencyKind dependencyKind = dependenciesSchema.get(i);
                    throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_DATAVERSE_DEPENDENT_EXISTS, new Serializable[]{dependencyKind, dependencyKind.getDependencyDisplayName(dependency), "view", DatasetUtil.getFullyQualifiedDisplayName(dataset)});
                }
            }
        }
        List<Function> functions = this.getAllFunctions(txnId);
        for (Function function : functions) {
            if (function.getDataverseName().equals((Object)dataverseName)) continue;
            dependenciesSchema = Function.DEPENDENCIES_SCHEMA;
            dependencies = function.getDependencies();
            n = dependencies.size();
            for (i = 0; i < n; ++i) {
                for (Triple<DataverseName, String, String> dependency : dependencies.get(i)) {
                    if (!((DataverseName)dependency.first).equals((Object)dataverseName)) continue;
                    DependencyKind dependencyKind = dependenciesSchema.get(i);
                    throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_DATAVERSE_DEPENDENT_EXISTS, new Serializable[]{dependencyKind, dependencyKind.getDependencyDisplayName(dependency), "function", function.getSignature()});
                }
            }
        }
        List<FeedConnection> list = this.getAllFeedConnections(txnId);
        for (FeedConnection feedConnection : list) {
            if (dataverseName.equals((Object)feedConnection.getDataverseName())) continue;
            for (FunctionSignature functionSignature : feedConnection.getAppliedFunctions()) {
                if (!dataverseName.equals((Object)functionSignature.getDataverseName())) continue;
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_DATAVERSE_DEPENDENT_EXISTS, new Serializable[]{"function", functionSignature, "feed connection", MetadataUtil.getFullyQualifiedDisplayName(feedConnection.getDataverseName(), feedConnection.getFeedName())});
            }
        }
    }

    private void confirmFunctionCanBeDeleted(TxnId txnId, FunctionSignature signature) throws AlgebricksException {
        this.confirmFunctionIsUnusedByViews(txnId, signature);
        this.confirmFunctionIsUnusedByFunctions(txnId, signature);
        List<FeedConnection> feedConnections = this.getAllFeedConnections(txnId);
        for (FeedConnection feedConnection : feedConnections) {
            if (!feedConnection.containsFunction(signature)) continue;
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_OBJECT_DEPENDENT_EXISTS, new Serializable[]{"function", signature, "feed connection", MetadataUtil.getFullyQualifiedDisplayName(feedConnection.getDataverseName(), feedConnection.getFeedName())});
        }
    }

    private void confirmFunctionIsUnusedByViews(TxnId txnId, FunctionSignature signature) throws AlgebricksException {
        this.confirmObjectIsUnusedByViews(txnId, "function", DependencyKind.FUNCTION, signature.getDataverseName(), signature.getName(), Integer.toString(signature.getArity()));
    }

    private void confirmFunctionIsUnusedByFunctions(TxnId txnId, FunctionSignature signature) throws AlgebricksException {
        this.confirmObjectIsUnusedByFunctions(txnId, "function", DependencyKind.FUNCTION, signature.getDataverseName(), signature.getName(), Integer.toString(signature.getArity()));
    }

    private void confirmObjectIsUnusedByFunctions(TxnId txnId, String objectKindDisplayName, DependencyKind dependencyKind, DataverseName dataverseName, String objectName, String objectArg) throws AlgebricksException {
        List<Function> functions = this.getAllFunctions(txnId);
        this.confirmObjectIsUnusedByFunctionsImpl(functions, objectKindDisplayName, dependencyKind, dataverseName, objectName, objectArg);
    }

    private void confirmObjectIsUnusedByFunctionsImpl(List<Function> allFunctions, String objectKindDisplayName, DependencyKind dependencyKind, DataverseName dataverseName, String objectName, String objectArg) throws AlgebricksException {
        int functionDependencyIdx = Function.DEPENDENCIES_SCHEMA.indexOf((Object)dependencyKind);
        if (functionDependencyIdx < 0) {
            throw new AlgebricksException(ErrorCode.ILLEGAL_STATE, new Serializable[0]);
        }
        for (Function function : allFunctions) {
            List<Triple<DataverseName, String, String>> functionObjectDependencies;
            List<List<Triple<DataverseName, String, String>>> functionDependencies = function.getDependencies();
            if (functionDependencyIdx >= functionDependencies.size() || (functionObjectDependencies = functionDependencies.get(functionDependencyIdx)) == null) continue;
            for (Triple<DataverseName, String, String> dependency : functionObjectDependencies) {
                if (!((DataverseName)dependency.first).equals((Object)dataverseName) || !((String)dependency.second).equals(objectName) || objectArg != null && !objectArg.equals(dependency.third)) continue;
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_OBJECT_DEPENDENT_EXISTS, new Serializable[]{objectKindDisplayName, dependencyKind.getDependencyDisplayName(dependency), "function", function.getSignature()});
            }
        }
    }

    private void confirmObjectIsUnusedByViews(TxnId txnId, String objectKindDisplayName, DependencyKind dependencyKind, DataverseName dataverseName, String objectName, String objectArg) throws AlgebricksException {
        List<Dataset> datasets = this.getAllDatasets(txnId);
        this.confirmObjectIsUnusedByViewsImpl(datasets, objectKindDisplayName, dependencyKind, dataverseName, objectName, objectArg);
    }

    private void confirmObjectIsUnusedByViewsImpl(List<Dataset> allDatasets, String objectKindDisplayName, DependencyKind dependencyKind, DataverseName dataverseName, String objectName, String objectArg) throws AlgebricksException {
        int viewDependencyIdx = ViewDetails.DEPENDENCIES_SCHEMA.indexOf((Object)dependencyKind);
        if (viewDependencyIdx < 0) {
            throw new AlgebricksException(ErrorCode.ILLEGAL_STATE, new Serializable[0]);
        }
        for (Dataset dataset : allDatasets) {
            List<Triple<DataverseName, String, String>> viewObjectDependencies;
            ViewDetails viewDetails;
            List<List<Triple<DataverseName, String, String>>> viewDependencies;
            if (dataset.getDatasetType() != DatasetConfig.DatasetType.VIEW || viewDependencyIdx >= (viewDependencies = (viewDetails = (ViewDetails)dataset.getDatasetDetails()).getDependencies()).size() || (viewObjectDependencies = viewDependencies.get(viewDependencyIdx)) == null) continue;
            for (Triple<DataverseName, String, String> dependency : viewObjectDependencies) {
                if (!((DataverseName)dependency.first).equals((Object)dataverseName) || !((String)dependency.second).equals(objectName) || objectArg != null && !objectArg.equals(dependency.third)) continue;
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_OBJECT_DEPENDENT_EXISTS, new Serializable[]{objectKindDisplayName, dependencyKind.getDependencyDisplayName(dependency), "view", DatasetUtil.getFullyQualifiedDisplayName(dataset)});
            }
        }
    }

    private void confirmFullTextConfigCanBeDeleted(TxnId txnId, DataverseName dataverseNameFullTextConfig, String configName) throws AlgebricksException {
        if (Strings.isNullOrEmpty((String)configName)) {
            throw new MetadataException(org.apache.asterix.common.exceptions.ErrorCode.FULL_TEXT_DEFAULT_CONFIG_CANNOT_BE_DELETED_OR_CREATED, new Serializable[0]);
        }
        List<Dataset> datasets = this.getAllDatasets(txnId);
        for (Dataset dataset : datasets) {
            List<Index> indexes = this.getDatasetIndexes(txnId, dataset.getDataverseName(), dataset.getDatasetName());
            for (Index index : indexes) {
                if (Index.IndexCategory.of(index.getIndexType()) != Index.IndexCategory.TEXT) continue;
                String indexConfigName = ((Index.TextIndexDetails)index.getIndexDetails()).getFullTextConfigName();
                if (!index.getDataverseName().equals((Object)dataverseNameFullTextConfig) || Strings.isNullOrEmpty((String)indexConfigName) || !indexConfigName.equals(configName)) continue;
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_OBJECT_DEPENDENT_EXISTS, new Serializable[]{"full-text config", MetadataUtil.getFullyQualifiedDisplayName(dataverseNameFullTextConfig, configName), "index", DatasetUtil.getFullyQualifiedDisplayName(index.getDataverseName(), index.getDatasetName()) + "." + index.getIndexName()});
            }
        }
    }

    private void confirmDatasetCanBeDeleted(TxnId txnId, String datasetTypeDisplayName, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        this.confirmDatasetIsUnusedByFunctions(txnId, datasetTypeDisplayName, dataverseName, datasetName);
        this.confirmDatasetIsUnusedByViews(txnId, datasetTypeDisplayName, dataverseName, datasetName);
    }

    private void confirmDatasetIsUnusedByFunctions(TxnId txnId, String datasetKindDisplayName, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        this.confirmObjectIsUnusedByFunctions(txnId, datasetKindDisplayName, DependencyKind.DATASET, dataverseName, datasetName, null);
    }

    private void confirmDatasetIsUnusedByViews(TxnId txnId, String datasetKindDisplayName, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        this.confirmObjectIsUnusedByViews(txnId, datasetKindDisplayName, DependencyKind.DATASET, dataverseName, datasetName, null);
    }

    private void confirmLibraryCanBeDeleted(TxnId txnId, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        this.confirmLibraryIsUnusedByFunctions(txnId, dataverseName, libraryName);
        this.confirmLibraryIsUnusedByAdapters(txnId, dataverseName, libraryName);
    }

    private void confirmLibraryIsUnusedByFunctions(TxnId txnId, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        List<Function> functions = this.getAllFunctions(txnId);
        for (Function function : functions) {
            if (!libraryName.equals(function.getLibraryName()) || !dataverseName.equals((Object)function.getLibraryDataverseName())) continue;
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_OBJECT_DEPENDENT_EXISTS, new Serializable[]{"library", MetadataUtil.getFullyQualifiedDisplayName(dataverseName, libraryName), "function", function.getSignature()});
        }
    }

    private void confirmLibraryIsUnusedByAdapters(TxnId txnId, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        List<DatasourceAdapter> adapters = this.getAllAdapters(txnId);
        for (DatasourceAdapter adapter : adapters) {
            if (!libraryName.equals(adapter.getLibraryName()) || !dataverseName.equals((Object)adapter.getLibraryDataverseName())) continue;
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_OBJECT_DEPENDENT_EXISTS, new Serializable[]{"library", MetadataUtil.getFullyQualifiedDisplayName(dataverseName, libraryName), "adapter", MetadataUtil.getFullyQualifiedDisplayName(adapter.getAdapterIdentifier().getDataverseName(), adapter.getAdapterIdentifier().getName())});
        }
    }

    private void confirmDatatypeIsUnused(TxnId txnId, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        this.confirmDatatypeIsUnusedByDatatypes(txnId, dataverseName, datatypeName);
        this.confirmDatatypeIsUnusedByDatasets(txnId, dataverseName, datatypeName);
        this.confirmDatatypeIsUnusedByFunctions(txnId, dataverseName, datatypeName);
    }

    private void confirmDatatypeIsUnusedByDatasets(TxnId txnId, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        List<Dataset> datasets = this.getAllDatasets(txnId);
        for (Dataset dataset : datasets) {
            if ((!dataset.getItemTypeName().equals(datatypeName) || !dataset.getItemTypeDataverseName().equals((Object)dataverseName)) && (!dataset.hasMetaPart() || !dataset.getMetaItemTypeName().equals(datatypeName) || !dataset.getMetaItemTypeDataverseName().equals((Object)dataverseName))) continue;
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_OBJECT_DEPENDENT_EXISTS, new Serializable[]{"type", TypeUtil.getFullyQualifiedDisplayName(dataverseName, datatypeName), IdentifierUtil.dataset(), DatasetUtil.getFullyQualifiedDisplayName(dataset)});
        }
        this.confirmObjectIsUnusedByViewsImpl(datasets, null, DependencyKind.TYPE, dataverseName, datatypeName, null);
    }

    private void confirmDatatypeIsUnusedByDatatypes(TxnId txnId, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        Datatype dataTypeToBeDropped = this.getDatatype(txnId, dataverseName, datatypeName);
        assert (dataTypeToBeDropped != null);
        IAType typeToBeDropped = dataTypeToBeDropped.getDatatype();
        List<Datatype> datatypes = this.getAllDatatypes(txnId);
        for (Datatype dataType : datatypes) {
            AbstractComplexType recType;
            if (!dataType.getDataverseName().equals((Object)dataverseName) || dataType.getDatatype().getTypeName().equals(datatypeName) || !(recType = (AbstractComplexType)dataType.getDatatype()).containsType(typeToBeDropped)) continue;
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.CANNOT_DROP_OBJECT_DEPENDENT_EXISTS, new Serializable[]{"type", TypeUtil.getFullyQualifiedDisplayName(dataverseName, datatypeName), "type", TypeUtil.getFullyQualifiedDisplayName(dataverseName, recType.getTypeName())});
        }
    }

    private void confirmDatatypeIsUnusedByFunctions(TxnId txnId, DataverseName dataverseName, String dataTypeName) throws AlgebricksException {
        this.confirmObjectIsUnusedByFunctions(txnId, "datatype", DependencyKind.TYPE, dataverseName, dataTypeName, null);
    }

    private void confirmFullTextFilterCanBeDeleted(TxnId txnId, DataverseName dataverseName, String fullTextFilterName) throws AlgebricksException {
        List<FullTextConfigMetadataEntity> configMetadataEntities = this.getDataverseFullTextConfigs(txnId, dataverseName);
        for (FullTextConfigMetadataEntity configMetadataEntity : configMetadataEntities) {
            FullTextConfigDescriptor config = configMetadataEntity.getFullTextConfig();
            for (String filterName : config.getFilterNames()) {
                if (!filterName.equals(fullTextFilterName)) continue;
                throw new AlgebricksException("Cannot drop full-text filter " + TypeUtil.getFullyQualifiedDisplayName(dataverseName, fullTextFilterName) + " being used by full-text config " + TypeUtil.getFullyQualifiedDisplayName(dataverseName, config.getName()));
            }
        }
    }

    private List<String> getNestedComplexDatatypeNamesForThisDatatype(TxnId txnId, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        ARecordType recType;
        Datatype parentType = this.getDatatype(txnId, dataverseName, datatypeName);
        List subTypes = null;
        if (parentType.getDatatype().getTypeTag() == ATypeTag.OBJECT) {
            recType = (ARecordType)parentType.getDatatype();
            subTypes = Arrays.asList(recType.getFieldTypes());
        } else if (parentType.getDatatype().getTypeTag() == ATypeTag.UNION) {
            recType = (AUnionType)parentType.getDatatype();
            subTypes = recType.getUnionList();
        }
        ArrayList<String> nestedTypes = new ArrayList<String>();
        if (subTypes != null) {
            for (IAType subType : subTypes) {
                if (subType instanceof BuiltinType) continue;
                nestedTypes.add(subType.getTypeName());
            }
        }
        return nestedTypes;
    }

    private List<Dataset> getDatasetsPartitionedOnThisNodeGroup(TxnId txnId, String nodegroup) throws AlgebricksException {
        ArrayList<Dataset> nodeGroupDatasets = new ArrayList<Dataset>();
        List<Dataset> datasets = this.getAllDatasets(txnId);
        for (Dataset set : datasets) {
            if (!set.getNodeGroupName().equals(nodegroup)) continue;
            nodeGroupDatasets.add(set);
        }
        return nodeGroupDatasets;
    }

    @Override
    public Index getIndex(TxnId txnId, DataverseName dataverseName, String datasetName, String indexName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName, indexName);
            IndexTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getIndexTupleTranslator(txnId, this, false);
            MetadataEntityValueExtractor<Index> valueExtractor = new MetadataEntityValueExtractor<Index>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Index)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Index> getDatasetIndexes(TxnId txnId, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName);
            IndexTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getIndexTupleTranslator(txnId, this, false);
            MetadataEntityValueExtractor<Index> valueExtractor = new MetadataEntityValueExtractor<Index>(tupleReaderWriter);
            ArrayList<Index> results = new ArrayList<Index>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Datatype getDatatype(TxnId txnId, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datatypeName);
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(txnId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Datatype)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public NodeGroup getNodeGroup(TxnId txnId, String nodeGroupName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(nodeGroupName, new String[0]);
            NodeGroupTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getNodeGroupTupleTranslator(false);
            MetadataEntityValueExtractor<NodeGroup> valueExtractor = new MetadataEntityValueExtractor<NodeGroup>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.NODEGROUP_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (NodeGroup)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Function getFunction(TxnId txnId, FunctionSignature functionSignature) throws AlgebricksException {
        List<Function> functions = this.getFunctionsImpl(txnId, MetadataNode.createTuple(functionSignature.getDataverseName(), functionSignature.getName(), Integer.toString(functionSignature.getArity())));
        return functions.isEmpty() ? null : functions.get(0);
    }

    @Override
    public List<Function> getDataverseFunctions(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        return this.getFunctionsImpl(txnId, MetadataNode.createTuple(dataverseName, new String[0]));
    }

    private List<Function> getFunctionsImpl(TxnId txnId, ITupleReference searchKey) throws AlgebricksException {
        try {
            FunctionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFunctionTupleTranslator(txnId, this, false);
            ArrayList<Function> results = new ArrayList<Function>();
            MetadataEntityValueExtractor<Function> valueExtractor = new MetadataEntityValueExtractor<Function>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropFunction(TxnId txnId, FunctionSignature functionSignature) throws AlgebricksException {
        this.dropFunction(txnId, functionSignature, false);
    }

    private void dropFunction(TxnId txnId, FunctionSignature functionSignature, boolean force) throws AlgebricksException {
        if (!force) {
            this.confirmFunctionCanBeDeleted(txnId, functionSignature);
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(functionSignature.getDataverseName(), functionSignature.getName(), Integer.toString(functionSignature.getArity()));
            ITupleReference functionTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.FUNCTION_DATASET, functionTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_FUNCTION, (Throwable)e, new Serializable[]{functionSignature.toString()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    private ITupleReference getTupleToBeDeleted(TxnId txnId, IMetadataIndex metadataIndex, ITupleReference searchKey) throws AlgebricksException, HyracksDataException {
        TupleCopyValueExtractor valueExtractor = new TupleCopyValueExtractor(metadataIndex.getTypeTraits(), TypeTraitProvider.INSTANCE.getTypeTrait((Object)BuiltinType.ANULL), NullIntrospector.INSTANCE);
        ArrayList results = new ArrayList();
        this.searchIndex(txnId, metadataIndex, searchKey, valueExtractor, results);
        if (results.isEmpty()) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY, (Serializable[])new Serializable[0]);
        }
        return (ITupleReference)results.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String printMetadata() {
        StringBuilder sb = new StringBuilder();
        try {
            IMetadataIndex index = MetadataPrimaryIndexes.DATAVERSE_DATASET;
            String resourceName = index.getFile().toString();
            IIndex indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
            this.datasetLifecycleManager.open(resourceName);
            IIndexAccessor indexAccessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            IIndexCursor rangeCursor = indexAccessor.createSearchCursor(false);
            try {
                RangePredicate rangePred = new RangePredicate(null, null, true, true, null, null);
                indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
                try {
                    while (rangeCursor.hasNext()) {
                        rangeCursor.next();
                        sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                    }
                }
                finally {
                    rangeCursor.close();
                }
                this.datasetLifecycleManager.close(resourceName);
                indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
                this.datasetLifecycleManager.open(resourceName);
                indexAccessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                rangeCursor = indexAccessor.createSearchCursor(false);
                rangePred = new RangePredicate(null, null, true, true, null, null);
                indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
                try {
                    while (rangeCursor.hasNext()) {
                        rangeCursor.next();
                        sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                    }
                }
                finally {
                    rangeCursor.close();
                }
                this.datasetLifecycleManager.close(resourceName);
                indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
                this.datasetLifecycleManager.open(resourceName);
                indexAccessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                rangeCursor = indexAccessor.createSearchCursor(false);
                rangePred = new RangePredicate(null, null, true, true, null, null);
                indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
                try {
                    while (rangeCursor.hasNext()) {
                        rangeCursor.next();
                        sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                    }
                }
                finally {
                    rangeCursor.close();
                }
            }
            finally {
                rangeCursor.destroy();
            }
            this.datasetLifecycleManager.close(resourceName);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void searchIndex(TxnId txnId, IMetadataIndex index, ITupleReference searchKey, IValueExtractor<T> valueExtractor, List<T> results) throws AlgebricksException, HyracksDataException {
        IBinaryComparatorFactory[] comparatorFactories = index.getKeyBinaryComparatorFactory();
        if (index.getFile() == null) {
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.METADATA_ERROR, new Serializable[]{"No file for Index " + index.getDataverseName() + "." + index.getIndexName()});
        }
        String resourceName = index.getFile().getRelativePath();
        IIndex indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
        this.datasetLifecycleManager.open(resourceName);
        IIndexAccessor indexAccessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        try {
            IBinaryComparator[] searchCmps = null;
            MultiComparator searchCmp = null;
            if (searchKey != null) {
                searchCmps = new IBinaryComparator[searchKey.getFieldCount()];
                for (int i = 0; i < searchKey.getFieldCount(); ++i) {
                    searchCmps[i] = comparatorFactories[i].createBinaryComparator();
                }
                searchCmp = new MultiComparator(searchCmps);
            }
            RangePredicate rangePred = new RangePredicate(searchKey, searchKey, true, true, searchCmp, searchCmp);
            this.search(indexAccessor, rangePred, results, valueExtractor, txnId);
        }
        finally {
            indexAccessor.destroy();
        }
        this.datasetLifecycleManager.close(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void search(IIndexAccessor indexAccessor, RangePredicate rangePred, List<T> results, IValueExtractor<T> valueExtractor, TxnId txnId) throws HyracksDataException, AlgebricksException {
        IIndexCursor rangeCursor = indexAccessor.createSearchCursor(false);
        try {
            indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
            try {
                while (rangeCursor.hasNext()) {
                    rangeCursor.next();
                    T result = valueExtractor.getValue(txnId, rangeCursor.getTuple());
                    if (result == null) continue;
                    results.add(result);
                }
            }
            finally {
                rangeCursor.close();
            }
        }
        finally {
            rangeCursor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeDatasetIdFactory(TxnId txnId) throws AlgebricksException {
        int mostRecentDatasetId;
        try {
            String resourceName = MetadataPrimaryIndexes.DATASET_DATASET.getFile().getRelativePath();
            IIndex indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
            this.datasetLifecycleManager.open(resourceName);
            try {
                mostRecentDatasetId = this.getMostRecentDatasetIdFromStoredDatasetIndex(indexInstance, txnId);
            }
            finally {
                this.datasetLifecycleManager.close(resourceName);
            }
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        DatasetIdFactory.initialize((int)mostRecentDatasetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMostRecentDatasetIdFromStoredDatasetIndex(IIndex indexInstance, TxnId txnId) throws HyracksDataException, AlgebricksException {
        DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
        MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
        RangePredicate rangePred = new RangePredicate(null, null, true, true, null, null);
        int mostRecentDatasetId = 100;
        IIndexAccessor indexAccessor = indexInstance.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        try {
            IIndexCursor rangeCursor = indexAccessor.createSearchCursor(false);
            try {
                indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
                try {
                    while (rangeCursor.hasNext()) {
                        rangeCursor.next();
                        ITupleReference ref = rangeCursor.getTuple();
                        Dataset ds = (Dataset)valueExtractor.getValue(txnId, ref);
                        int datasetId = Math.max(ds.getDatasetId(), DatasetIdFactory.generateAlternatingDatasetId((int)ds.getDatasetId()));
                        if (mostRecentDatasetId >= datasetId) continue;
                        mostRecentDatasetId = datasetId;
                    }
                }
                finally {
                    rangeCursor.close();
                }
            }
            finally {
                rangeCursor.destroy();
            }
        }
        finally {
            indexAccessor.destroy();
        }
        return mostRecentDatasetId;
    }

    public static ITupleReference createTuple(DataverseName dataverseName, String ... rest) {
        return MetadataNode.createTuple(dataverseName.getCanonicalForm(), rest);
    }

    public static ITupleReference createTuple(String first, String ... rest) {
        try {
            ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(1 + rest.length);
            ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
            AMutableString aString = new AMutableString(first);
            stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
            tupleBuilder.addFieldEndOffset();
            for (String s : rest) {
                aString.setValue(s);
                stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
                tupleBuilder.addFieldEndOffset();
            }
            ArrayTupleReference tuple = new ArrayTupleReference();
            tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
            return tuple;
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException("Failed to create search tuple", e);
        }
    }

    public static ITupleReference createTuple() {
        ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(0);
        ArrayTupleReference tuple = new ArrayTupleReference();
        tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
        return tuple;
    }

    @Override
    public void addAdapter(TxnId txnId, DatasourceAdapter adapter) throws AlgebricksException {
        try {
            DatasourceAdapterTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getAdapterTupleTranslator(true);
            ITupleReference adapterTuple = tupleReaderWriter.getTupleFromMetadataEntity(adapter);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, adapterTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.ADAPTER_EXISTS, (Throwable)e, new Serializable[]{adapter.getAdapterIdentifier().getName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropAdapter(TxnId txnId, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, adapterName);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, datasetTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_ADAPTER, (Throwable)e, new Serializable[]{adapterName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public DatasourceAdapter getAdapter(TxnId txnId, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, adapterName);
            DatasourceAdapterTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getAdapterTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<DatasourceAdapter> valueExtractor = new MetadataEntityValueExtractor<DatasourceAdapter>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (DatasourceAdapter)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addCompactionPolicy(TxnId txnId, CompactionPolicy compactionPolicy) throws AlgebricksException {
        try {
            CompactionPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getCompactionPolicyTupleTranslator(true);
            ITupleReference compactionPolicyTuple = tupleReaderWriter.getTupleFromMetadataEntity(compactionPolicy);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, compactionPolicyTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.COMPACTION_POLICY_EXISTS, (Throwable)e, new Serializable[]{compactionPolicy.getPolicyName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public CompactionPolicy getCompactionPolicy(TxnId txnId, DataverseName dataverseName, String policyName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, policyName);
            CompactionPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getCompactionPolicyTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<CompactionPolicy> valueExtractor = new MetadataEntityValueExtractor<CompactionPolicy>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (CompactionPolicy)results.get(0);
            }
            return null;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<DatasourceAdapter> getDataverseAdapters(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
            DatasourceAdapterTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getAdapterTupleTranslator(false);
            MetadataEntityValueExtractor<DatasourceAdapter> valueExtractor = new MetadataEntityValueExtractor<DatasourceAdapter>(tupleReaderWriter);
            ArrayList<DatasourceAdapter> results = new ArrayList<DatasourceAdapter>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addLibrary(TxnId txnId, Library library) throws AlgebricksException {
        try {
            LibraryTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getLibraryTupleTranslator(true);
            ITupleReference libraryTuple = tupleReaderWriter.getTupleFromMetadataEntity(library);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.LIBRARY_DATASET, libraryTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.LIBRARY_EXISTS, (Throwable)e, new Serializable[]{library.getName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropLibrary(TxnId txnId, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        this.dropLibrary(txnId, dataverseName, libraryName, false);
    }

    private void dropLibrary(TxnId txnId, DataverseName dataverseName, String libraryName, boolean force) throws AlgebricksException {
        if (!force) {
            this.confirmLibraryCanBeDeleted(txnId, dataverseName, libraryName);
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, libraryName);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.LIBRARY_DATASET, datasetTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_LIBRARY, (Throwable)e, new Serializable[]{libraryName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Library getLibrary(TxnId txnId, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, libraryName);
            LibraryTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getLibraryTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Library> valueExtractor = new MetadataEntityValueExtractor<Library>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Library)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public int getMostRecentDatasetId() throws RemoteException {
        return DatasetIdFactory.getMostRecentDatasetId();
    }

    @Override
    public void addFeedPolicy(TxnId txnId, FeedPolicyEntity feedPolicy) throws AlgebricksException {
        try {
            FeedPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedPolicyTupleTranslator(true);
            ITupleReference feedPolicyTuple = tupleReaderWriter.getTupleFromMetadataEntity(feedPolicy);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, feedPolicyTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.FEED_POLICY_EXISTS, (Throwable)e, new Serializable[]{feedPolicy.getPolicyName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public FeedPolicyEntity getFeedPolicy(TxnId txnId, DataverseName dataverseName, String policyName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, policyName);
            FeedPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedPolicyTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<FeedPolicyEntity> valueExtractor = new MetadataEntityValueExtractor<FeedPolicyEntity>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (FeedPolicyEntity)results.get(0);
            }
            return null;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addFeedConnection(TxnId txnId, FeedConnection feedConnection) throws AlgebricksException {
        try {
            FeedConnectionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedConnectionTupleTranslator(true);
            ITupleReference feedConnTuple = tupleReaderWriter.getTupleFromMetadataEntity(feedConnection);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, feedConnTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.FEED_CONNECTION_EXISTS, (Throwable)e, new Serializable[]{feedConnection.getFeedName(), feedConnection.getDatasetName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<FeedConnection> getFeedConnections(TxnId txnId, DataverseName dataverseName, String feedName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName);
            FeedConnectionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedConnectionTupleTranslator(false);
            ArrayList<FeedConnection> results = new ArrayList<FeedConnection>();
            MetadataEntityValueExtractor<FeedConnection> valueExtractor = new MetadataEntityValueExtractor<FeedConnection>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public FeedConnection getFeedConnection(TxnId txnId, DataverseName dataverseName, String feedName, String datasetName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName, datasetName);
            FeedConnectionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedConnectionTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<FeedConnection> valueExtractor = new MetadataEntityValueExtractor<FeedConnection>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (FeedConnection)results.get(0);
            }
            return null;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropFeedConnection(TxnId txnId, DataverseName dataverseName, String feedName, String datasetName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName, datasetName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_FEED_CONNECTION, (Throwable)e, new Serializable[]{feedName, datasetName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addFeed(TxnId txnId, Feed feed) throws AlgebricksException {
        try {
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(true);
            ITupleReference feedTuple = tupleReaderWriter.getTupleFromMetadataEntity(feed);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.FEED_DATASET, feedTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.FEED_EXISTS, (Throwable)e, new Serializable[]{feed.getFeedName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public Feed getFeed(TxnId txnId, DataverseName dataverseName, String feedName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName);
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Feed> valueExtractor = new MetadataEntityValueExtractor<Feed>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (Feed)results.get(0);
            }
            return null;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Feed> getFeeds(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(false);
            ArrayList<Feed> results = new ArrayList<Feed>();
            MetadataEntityValueExtractor<Feed> valueExtractor = new MetadataEntityValueExtractor<Feed>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropFeed(TxnId txnId, DataverseName dataverseName, String feedName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.FEED_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.FEED_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_FEED, (Throwable)e, new Serializable[]{feedName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropFeedPolicy(TxnId txnId, DataverseName dataverseName, String policyName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, policyName);
            ITupleReference tuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, tuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_FEED_POLICY, (Throwable)e, new Serializable[]{policyName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<FeedPolicyEntity> getDataverseFeedPolicies(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
            FeedPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedPolicyTupleTranslator(false);
            MetadataEntityValueExtractor<FeedPolicyEntity> valueExtractor = new MetadataEntityValueExtractor<FeedPolicyEntity>(tupleReaderWriter);
            ArrayList<FeedPolicyEntity> results = new ArrayList<FeedPolicyEntity>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addExternalFile(TxnId txnId, ExternalFile externalFile) throws AlgebricksException {
        try {
            ExternalFileTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getExternalFileTupleTranslator(true);
            ITupleReference externalFileTuple = tupleReaderWriter.getTupleFromMetadataEntity(externalFile);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, externalFileTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.EXTERNAL_FILE_EXISTS, (Throwable)e, new Serializable[]{Integer.valueOf(externalFile.getFileNumber()), externalFile.getDatasetName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<ExternalFile> getExternalFiles(TxnId txnId, Dataset dataset) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataset.getDataverseName(), dataset.getDatasetName());
            ExternalFileTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getExternalFileTupleTranslator(false);
            MetadataEntityValueExtractor<ExternalFile> valueExtractor = new MetadataEntityValueExtractor<ExternalFile>(tupleReaderWriter);
            ArrayList<ExternalFile> results = new ArrayList<ExternalFile>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropExternalFile(TxnId txnId, DataverseName dataverseName, String datasetName, int fileNumber) throws AlgebricksException {
        try {
            ITupleReference searchKey = this.createExternalFileSearchTuple(dataverseName, datasetName, fileNumber);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, datasetTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_EXTERNAL_FILE, (Throwable)e, new Serializable[]{Integer.valueOf(fileNumber), datasetName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropExternalFiles(TxnId txnId, Dataset dataset) throws AlgebricksException {
        List<ExternalFile> files = this.getExternalFiles(txnId, dataset);
        for (int i = 0; i < files.size(); ++i) {
            this.dropExternalFile(txnId, files.get(i).getDataverseName(), files.get(i).getDatasetName(), files.get(i).getFileNumber());
        }
    }

    public ITupleReference createExternalFileSearchTuple(DataverseName dataverseName, String datasetName, int fileNumber) throws HyracksDataException {
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        ISerializerDeserializer intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
        AMutableString aString = new AMutableString("");
        ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(3);
        aString.setValue(dataverseName.getCanonicalForm());
        stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        aString.setValue(datasetName);
        stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        intSerde.serialize((Object)new AInt32(fileNumber), tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        ArrayTupleReference tuple = new ArrayTupleReference();
        tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
        return tuple;
    }

    @Override
    public ExternalFile getExternalFile(TxnId txnId, DataverseName dataverseName, String datasetName, Integer fileNumber) throws AlgebricksException {
        try {
            ITupleReference searchKey = this.createExternalFileSearchTuple(dataverseName, datasetName, fileNumber);
            ExternalFileTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getExternalFileTupleTranslator(false);
            MetadataEntityValueExtractor<ExternalFile> valueExtractor = new MetadataEntityValueExtractor<ExternalFile>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(txnId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (ExternalFile)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void addSynonym(TxnId txnId, Synonym synonym) throws AlgebricksException {
        try {
            SynonymTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getSynonymTupleTranslator(true);
            ITupleReference synonymTuple = tupleReaderWriter.getTupleFromMetadataEntity(synonym);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.SYNONYM_DATASET, synonymTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.SYNONYM_EXISTS, (Throwable)e, new Serializable[]{synonym.getSynonymName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void dropSynonym(TxnId txnId, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        this.dropSynonym(txnId, dataverseName, synonymName, false);
    }

    private void dropSynonym(TxnId txnId, DataverseName dataverseName, String synonymName, boolean force) throws AlgebricksException {
        if (!force) {
            this.confirmSynonymCanBeDeleted(txnId, dataverseName, synonymName);
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, synonymName);
            ITupleReference synonymTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.SYNONYM_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.SYNONYM_DATASET, synonymTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_SYNONYM, (Throwable)e, new Serializable[]{synonymName});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    private void confirmSynonymCanBeDeleted(TxnId txnId, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        this.confirmSynonymIsUnusedByFunctions(txnId, dataverseName, synonymName);
        this.confirmSynonymIsUnusedByViews(txnId, dataverseName, synonymName);
    }

    private void confirmSynonymIsUnusedByFunctions(TxnId txnId, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        this.confirmObjectIsUnusedByFunctions(txnId, "synonym", DependencyKind.SYNONYM, dataverseName, synonymName, null);
    }

    private void confirmSynonymIsUnusedByViews(TxnId txnId, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        this.confirmObjectIsUnusedByViews(txnId, "synonym", DependencyKind.SYNONYM, dataverseName, synonymName, null);
    }

    @Override
    public Synonym getSynonym(TxnId txnId, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, synonymName);
            SynonymTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getSynonymTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Synonym> valueExtractor = new MetadataEntityValueExtractor<Synonym>(tupleReaderWriter);
            this.searchIndex(txnId, MetadataPrimaryIndexes.SYNONYM_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Synonym)results.get(0);
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public List<Synonym> getDataverseSynonyms(TxnId txnId, DataverseName dataverseName) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, new String[0]);
            SynonymTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getSynonymTupleTranslator(false);
            MetadataEntityValueExtractor<Synonym> valueExtractor = new MetadataEntityValueExtractor<Synonym>(tupleReaderWriter);
            ArrayList<Synonym> results = new ArrayList<Synonym>();
            this.searchIndex(txnId, MetadataPrimaryIndexes.SYNONYM_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void updateDataset(TxnId txnId, Dataset dataset) throws AlgebricksException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataset.getDataverseName(), dataset.getDatasetName());
            ITupleReference datasetTuple = this.getTupleToBeDeleted(txnId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey);
            this.deleteTupleFromIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(true);
            datasetTuple = tupleReaderWriter.getTupleFromMetadataEntity(dataset);
            this.insertTupleIntoIndex(txnId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
        }
        catch (HyracksDataException e) {
            if (e.matches((IError)ErrorCode.UPDATE_OR_DELETE_NON_EXISTENT_KEY)) {
                throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, (Throwable)e, new Serializable[]{dataset.getDatasetName(), dataset.getDataverseName()});
            }
            throw new AlgebricksException((Throwable)e);
        }
    }

    @Override
    public void updateLibrary(TxnId txnId, Library library) throws AlgebricksException {
        this.dropLibrary(txnId, library.getDataverseName(), library.getName(), true);
        this.addLibrary(txnId, library);
    }

    @Override
    public void updateFunction(TxnId txnId, Function function) throws AlgebricksException {
        this.dropFunction(txnId, function.getSignature(), true);
        this.addFunction(txnId, function);
    }

    @Override
    public void updateDatatype(TxnId txnId, Datatype datatype) throws AlgebricksException {
        this.dropDatatype(txnId, datatype.getDataverseName(), datatype.getDatatypeName(), true);
        this.addDatatype(txnId, datatype);
    }

    public ITxnIdFactory getTxnIdFactory() {
        return this.txnIdFactory;
    }

    private ArrayNode getJsonNodes(TxnId txnId, IMetadataIndex mdIndex, int payloadPosition) throws AlgebricksException, HyracksDataException {
        IValueExtractor<JsonNode> valueExtractor = MetadataNode.createValueExtractor(mdIndex, payloadPosition);
        ArrayList results = new ArrayList();
        this.searchIndex(txnId, mdIndex, null, valueExtractor, results);
        ArrayNode array = JSONUtil.createArray();
        results.forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
        return array;
    }

    private static IValueExtractor<JsonNode> createValueExtractor(final IMetadataIndex mdIndex, final int payloadFieldIndex) {
        return new IValueExtractor<JsonNode>(){
            final ARecordType payloadRecordType;
            final IPrinterFactory printerFactory;
            final IPrinter printer;
            final ByteArrayAccessibleOutputStream outputStream;
            final PrintStream printStream;
            {
                this.payloadRecordType = mdIndex.getPayloadRecordType();
                this.printerFactory = CleanJSONPrinterFactoryProvider.INSTANCE.getPrinterFactory((Object)this.payloadRecordType);
                this.printer = this.printerFactory.createPrinter();
                this.outputStream = new ByteArrayAccessibleOutputStream();
                this.printStream = new PrintStream((OutputStream)this.outputStream);
            }

            @Override
            public JsonNode getValue(TxnId txnId, ITupleReference tuple) {
                try {
                    byte[] serRecord = tuple.getFieldData(payloadFieldIndex);
                    int recordStartOffset = tuple.getFieldStart(payloadFieldIndex);
                    int recordLength = tuple.getFieldLength(payloadFieldIndex);
                    this.printer.init();
                    this.outputStream.reset();
                    this.printer.print(serRecord, recordStartOffset, recordLength, this.printStream);
                    this.printStream.flush();
                    return JSONUtil.readTree((byte[])this.outputStream.getByteArray(), (int)0, (int)this.outputStream.getLength());
                }
                catch (Throwable th) {
                    return JSONUtil.createObject();
                }
            }
        };
    }
}

