/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet;

import java.io.IOException;
import org.apache.asterix.external.input.record.ValueReferenceRecord;
import org.apache.asterix.external.input.record.reader.hdfs.AbstractHDFSRecordReader;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.AsterixParquetRuntimeException;
import org.apache.asterix.external.util.HDFSUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.data.std.api.IValueReference;

public class ParquetFileRecordReader<V extends IValueReference>
extends AbstractHDFSRecordReader<Void, V> {
    private final IWarningCollector warningCollector;

    public ParquetFileRecordReader(boolean[] read, InputSplit[] inputSplits, String[] readSchedule, String nodeName, JobConf conf, IWarningCollector warningCollector) {
        super(read, inputSplits, readSchedule, nodeName, new ValueReferenceRecord(), conf);
        this.warningCollector = warningCollector;
    }

    @Override
    protected boolean onNextInputSplit() throws IOException {
        return false;
    }

    @Override
    public void close() throws IOException {
        super.close();
        HDFSUtils.issueWarnings(this.warningCollector, (Configuration)this.conf);
    }

    @Override
    protected RecordReader<Void, V> getRecordReader(int splitIndex) throws IOException {
        try {
            this.reader = this.inputFormat.getRecordReader(this.inputSplits[splitIndex], this.conf, Reporter.NULL);
        }
        catch (AsterixParquetRuntimeException e) {
            throw e.getHyracksDataException();
        }
        if (this.value == null) {
            this.value = this.reader.createValue();
        }
        return this.reader;
    }
}

