/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.rewriter.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.ActivityClusterId;
import org.apache.hyracks.api.rewriter.OneToOneConnectedActivityCluster;
import org.apache.hyracks.api.rewriter.runtime.SuperActivityOperatorNodePushable;

public class SuperActivity
extends OneToOneConnectedActivityCluster
implements IActivity {
    private static final long serialVersionUID = 1L;
    private final ActivityId activityId;

    public SuperActivity(ActivityClusterGraph acg, ActivityClusterId id, ActivityId activityId) {
        super(acg, id);
        this.activityId = activityId;
    }

    @Override
    public String getDisplayName() {
        return "SA";
    }

    @Override
    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, final IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final HashMap<ActivityId, IActivity> startActivities = new HashMap<ActivityId, IActivity>();
        Map<ActivityId, IActivity> activities = this.getActivityMap();
        activities.forEach((key, value) -> {
            List<IConnectorDescriptor> conns = this.getActivityInputMap().get(key);
            if (conns == null || conns.isEmpty()) {
                startActivities.put((ActivityId)key, (IActivity)value);
            }
        });
        IRecordDescriptorProvider wrappedRecDescProvider = new IRecordDescriptorProvider(){

            @Override
            public RecordDescriptor getInputRecordDescriptor(ActivityId aid, int inputIndex) {
                int superActivityInputChannel;
                if (startActivities.get(aid) != null && (superActivityInputChannel = SuperActivity.this.getClusterInputIndex((Pair<ActivityId, Integer>)Pair.of((Object)aid, (Object)inputIndex))) >= 0) {
                    return recordDescProvider.getInputRecordDescriptor(SuperActivity.this.activityId, superActivityInputChannel);
                }
                if (SuperActivity.this.getActivityMap().get(aid) != null) {
                    IConnectorDescriptor conn = SuperActivity.this.getActivityInputMap().get(aid).get(inputIndex);
                    return SuperActivity.this.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                }
                ActivityClusterGraph acg = SuperActivity.this.getActivityClusterGraph();
                for (Map.Entry<ActivityClusterId, ActivityCluster> entry : acg.getActivityClusterMap().entrySet()) {
                    ActivityCluster ac = entry.getValue();
                    for (Map.Entry<ActivityId, IActivity> saEntry : ac.getActivityMap().entrySet()) {
                        SuperActivity sa = (SuperActivity)saEntry.getValue();
                        if (sa.getActivityMap().get(aid) == null) continue;
                        List<IConnectorDescriptor> conns = sa.getActivityInputMap().get(aid);
                        if (conns != null && conns.size() >= inputIndex) {
                            IConnectorDescriptor conn = conns.get(inputIndex);
                            return sa.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                        }
                        int superActivityInputChannel2 = sa.getClusterInputIndex((Pair<ActivityId, Integer>)Pair.of((Object)aid, (Object)inputIndex));
                        if (superActivityInputChannel2 < 0) continue;
                        return recordDescProvider.getInputRecordDescriptor(sa.getActivityId(), superActivityInputChannel2);
                    }
                }
                return null;
            }

            @Override
            public RecordDescriptor getOutputRecordDescriptor(ActivityId aid, int outputIndex) {
                int superActivityOutputChannel = SuperActivity.this.getClusterOutputIndex((Pair<ActivityId, Integer>)Pair.of((Object)aid, (Object)outputIndex));
                if (superActivityOutputChannel >= 0) {
                    return recordDescProvider.getOutputRecordDescriptor(SuperActivity.this.activityId, superActivityOutputChannel);
                }
                if (SuperActivity.this.getActivityMap().get(aid) != null) {
                    IConnectorDescriptor conn = SuperActivity.this.getActivityOutputMap().get(aid).get(outputIndex);
                    return SuperActivity.this.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                }
                ActivityClusterGraph acg = SuperActivity.this.getActivityClusterGraph();
                for (Map.Entry<ActivityClusterId, ActivityCluster> entry : acg.getActivityClusterMap().entrySet()) {
                    ActivityCluster ac = entry.getValue();
                    for (Map.Entry<ActivityId, IActivity> saEntry : ac.getActivityMap().entrySet()) {
                        SuperActivity sa = (SuperActivity)saEntry.getValue();
                        if (sa.getActivityMap().get(aid) == null) continue;
                        List<IConnectorDescriptor> conns = sa.getActivityOutputMap().get(aid);
                        if (conns != null && conns.size() >= outputIndex) {
                            IConnectorDescriptor conn = conns.get(outputIndex);
                            return sa.getConnectorRecordDescriptorMap().get(conn.getConnectorId());
                        }
                        superActivityOutputChannel = sa.getClusterOutputIndex((Pair<ActivityId, Integer>)Pair.of((Object)aid, (Object)outputIndex));
                        if (superActivityOutputChannel < 0) continue;
                        return recordDescProvider.getOutputRecordDescriptor(sa.getActivityId(), superActivityOutputChannel);
                    }
                }
                return null;
            }
        };
        return new SuperActivityOperatorNodePushable(this, startActivities, ctx, wrappedRecDescProvider, partition, nPartitions);
    }

    @Override
    public ActivityId getActivityId() {
        return this.activityId;
    }

    public String toString() {
        return this.getActivityMap().values().toString();
    }
}

