/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.logging.ClientLogger;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class DateTimeRfc1123 {
    private static final ClientLogger LOGGER = new ClientLogger(DateTimeRfc1123.class);
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZone(ZoneId.of("UTC")).withLocale(Locale.US);
    private final OffsetDateTime dateTime;

    public DateTimeRfc1123(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public DateTimeRfc1123(String formattedString) {
        this.dateTime = DateTimeRfc1123.parse(formattedString);
    }

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    private static OffsetDateTime parse(String date) {
        try {
            return OffsetDateTime.of(DateTimeRfc1123.parseInt(date, 12, 16), DateTimeRfc1123.parseMonth(date, 8), DateTimeRfc1123.parseInt(date, 5, 7), DateTimeRfc1123.parseInt(date, 17, 19), DateTimeRfc1123.parseInt(date, 20, 22), DateTimeRfc1123.parseInt(date, 23, 25), 0, ZoneOffset.UTC);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | DateTimeException e) {
            return OffsetDateTime.parse(date, DateTimeFormatter.RFC_1123_DATE_TIME);
        }
    }

    private static int parseInt(CharSequence date, int beginIndex, int endIndex) {
        int num = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = date.charAt(i);
            if (c < '0' || c > '9') {
                throw LOGGER.logExceptionAsError(new DateTimeException("Invalid date time: " + date));
            }
            num = num * 10 + (c - 48);
        }
        return num;
    }

    private static int parseMonth(CharSequence date, int beginIndex) {
        switch (date.charAt(beginIndex)) {
            case 'J': {
                switch (date.charAt(beginIndex + 1)) {
                    case 'a': {
                        return 1;
                    }
                    case 'u': {
                        switch (date.charAt(beginIndex + 2)) {
                            case 'n': {
                                return 6;
                            }
                            case 'l': {
                                return 7;
                            }
                        }
                        throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + date));
                    }
                }
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + date));
            }
            case 'F': {
                return 2;
            }
            case 'M': {
                switch (date.charAt(beginIndex + 2)) {
                    case 'r': {
                        return 3;
                    }
                    case 'y': {
                        return 5;
                    }
                }
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + date));
            }
            case 'A': {
                switch (date.charAt(beginIndex + 2)) {
                    case 'r': {
                        return 4;
                    }
                    case 'g': {
                        return 8;
                    }
                }
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + date));
            }
            case 'S': {
                return 9;
            }
            case 'O': {
                return 10;
            }
            case 'N': {
                return 11;
            }
            case 'D': {
                return 12;
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown month " + date));
    }

    public String toString() {
        return RFC1123_DATE_TIME_FORMATTER.format(this.dateTime);
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeRfc1123)) {
            return false;
        }
        DateTimeRfc1123 rhs = (DateTimeRfc1123)obj;
        return this.dateTime.equals(rhs.getDateTime());
    }
}

