/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.VisualStudioCacheAccessor;
import com.azure.identity.implementation.util.LoggingUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class VisualStudioCodeCredential
implements TokenCredential {
    private final IdentityClient identityClient;
    private final AtomicReference<MsalToken> cachedToken;
    private final String cloudInstance;
    private final ClientLogger logger = new ClientLogger(VisualStudioCodeCredential.class);

    VisualStudioCodeCredential(String tenantId, IdentityClientOptions identityClientOptions) {
        IdentityClientOptions options = identityClientOptions == null ? new IdentityClientOptions() : identityClientOptions;
        VisualStudioCacheAccessor accessor = new VisualStudioCacheAccessor();
        Map<String, String> userSettings = accessor.getUserSettingsDetails();
        this.cloudInstance = userSettings.get("cloud");
        if (CoreUtils.isNullOrEmpty((CharSequence)options.getAuthorityHost())) {
            options.setAuthorityHost(accessor.getAzureAuthHost(this.cloudInstance));
        }
        String tenant = !CoreUtils.isNullOrEmpty((CharSequence)tenantId) ? tenantId : (userSettings.containsKey("tenant") ? userSettings.get("tenant") : "common");
        this.identityClient = new IdentityClientBuilder().tenantId(tenant).clientId("aebc6443-996d-45c2-90f0-388ff96faa56").identityClientOptions(options).build();
        this.cachedToken = new AtomicReference();
    }

    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(request, this.cachedToken.get().getAccount()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithVsCodeCredential(request, this.cloudInstance))).map(msalToken -> {
            this.cachedToken.set((MsalToken)((Object)msalToken));
            return msalToken;
        }).doOnNext(token -> LoggingUtil.logTokenSuccess(this.logger, request)).doOnError(error -> LoggingUtil.logTokenError(this.logger, request, error));
    }
}

