/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.io.netty.handler.ssl;

import com.couchbase.client.deps.io.netty.handler.ssl.OpenSslContext;
import com.couchbase.client.deps.io.netty.handler.ssl.OpenSslEngine;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import org.apache.tomcat.jni.SSL;

class OpenSslKeyMaterialManager {
    static final String KEY_TYPE_RSA = "RSA";
    static final String KEY_TYPE_DH_RSA = "DH_RSA";
    static final String KEY_TYPE_EC = "EC";
    static final String KEY_TYPE_EC_EC = "EC_EC";
    static final String KEY_TYPE_EC_RSA = "EC_RSA";
    private static final Map<String, String> KEY_TYPES = new HashMap<String, String>();
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialManager(X509KeyManager keyManager, String password) {
        this.keyManager = keyManager;
        this.password = password;
    }

    void setKeyMaterial(OpenSslEngine engine) throws SSLException {
        String[] authMethods;
        long ssl = engine.sslPointer();
        for (String authMethod : authMethods = SSL.authenticationMethods((long)ssl)) {
            String type = KEY_TYPES.get(authMethod);
            if (type == null) continue;
            this.setKeyMaterial(ssl, this.chooseServerAlias(engine, type));
        }
    }

    void setKeyMaterial(OpenSslEngine engine, String[] keyTypes, X500Principal[] issuer) throws SSLException {
        this.setKeyMaterial(engine.sslPointer(), this.chooseClientAlias(engine, keyTypes, issuer));
    }

    private void setKeyMaterial(long ssl, String alias) throws SSLException {
        long keyBio = 0L;
        long keyCertChainBio = 0L;
        try {
            PrivateKey key = this.keyManager.getPrivateKey(alias);
            X509Certificate[] certificates = this.keyManager.getCertificateChain(alias);
            if (certificates != null && certificates.length != 0) {
                keyCertChainBio = OpenSslContext.toBIO(this.keyManager.getCertificateChain(alias));
                if (key != null) {
                    keyBio = OpenSslContext.toBIO(key);
                }
                SSL.setCertificateBio((long)ssl, (long)keyCertChainBio, (long)keyBio, (String)this.password);
                SSL.setCertificateChainBio((long)ssl, (long)keyCertChainBio, (boolean)false);
            }
        }
        catch (SSLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
        finally {
            if (keyBio != 0L) {
                SSL.freeBIO((long)keyBio);
            }
            if (keyCertChainBio != 0L) {
                SSL.freeBIO((long)keyCertChainBio);
            }
        }
    }

    protected String chooseClientAlias(OpenSslEngine engine, String[] keyTypes, X500Principal[] issuer) {
        return this.keyManager.chooseClientAlias(keyTypes, issuer, null);
    }

    protected String chooseServerAlias(OpenSslEngine engine, String type) {
        return this.keyManager.chooseServerAlias(type, null, null);
    }

    static {
        KEY_TYPES.put(KEY_TYPE_RSA, KEY_TYPE_RSA);
        KEY_TYPES.put("DHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_ECDSA", KEY_TYPE_EC);
        KEY_TYPES.put("ECDH_RSA", KEY_TYPE_EC_RSA);
        KEY_TYPES.put("ECDH_ECDSA", KEY_TYPE_EC_EC);
        KEY_TYPES.put(KEY_TYPE_DH_RSA, KEY_TYPE_DH_RSA);
    }
}

