/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.api.http.server.AbstractRequestsServlet;
import org.apache.asterix.api.http.server.QueryServiceRequestParameters;
import org.apache.asterix.common.api.IClientRequest;
import org.apache.asterix.common.api.IRequestTracker;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActiveRequestsServlet
extends AbstractRequestsServlet {
    public static final String REQUEST_UUID_PARAM_NAME = "request_id";
    private static final Logger LOGGER = LogManager.getLogger();

    public ActiveRequestsServlet(ConcurrentMap<String, Object> ctx, ICcApplicationContext appCtx, String ... paths) {
        super(ctx, appCtx, paths);
    }

    @Override
    public Collection<IClientRequest> getRequests() {
        return this.appCtx.getRequestTracker().getRunningRequests();
    }

    protected void delete(IServletRequest request, IServletResponse response) throws IOException {
        IClientRequest req;
        String uuid = request.getParameter((CharSequence)REQUEST_UUID_PARAM_NAME);
        String clientCtxId = request.getParameter((CharSequence)QueryServiceRequestParameters.Parameter.CLIENT_ID.str());
        LOGGER.debug("received cancel request, uuid={}, clientCtxId={}", (Object)uuid, (Object)clientCtxId);
        if (uuid == null && clientCtxId == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        IRequestTracker requestTracker = this.appCtx.getRequestTracker();
        IClientRequest iClientRequest = req = uuid != null ? requestTracker.get(uuid) : requestTracker.getByClientContextId(clientCtxId);
        if (req == null) {
            response.setStatus(HttpResponseStatus.NOT_FOUND);
            return;
        }
        if (!req.isCancellable()) {
            response.setStatus(HttpResponseStatus.FORBIDDEN);
            return;
        }
        try {
            requestTracker.cancel(req.getId());
            response.setStatus(HttpResponseStatus.OK);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "unexpected exception thrown from cancel", (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

