/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.cc;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.asterix.app.message.AtomicJobCommitMessage;
import org.apache.asterix.app.message.AtomicJobRollbackMessage;
import org.apache.asterix.app.message.EnableMergeMessage;
import org.apache.asterix.common.cluster.IGlobalTxManager;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.transactions.IGlobalTransactionContext;
import org.apache.asterix.transaction.management.service.transaction.GlobalTransactionContext;
import org.apache.asterix.transaction.management.service.transaction.GlobalTxInfo;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalTxManager
implements IGlobalTxManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<JobId, IGlobalTransactionContext> txnContextRepository = new ConcurrentHashMap<JobId, IGlobalTransactionContext>();
    private final ICCServiceContext serviceContext;
    private final IOManager ioManager;
    public static final String GlOBAL_TX_PROPERTY_NAME = "GlobalTxProperty";

    public GlobalTxManager(ICCServiceContext serviceContext, IOManager ioManager) {
        this.serviceContext = serviceContext;
        this.ioManager = ioManager;
    }

    public IGlobalTransactionContext beginTransaction(JobId jobId, int numParticipatingNodes, int numParticipatingPartitions, List<Integer> participatingDatasetIds) throws ACIDException {
        GlobalTransactionContext context = new GlobalTransactionContext(jobId, participatingDatasetIds, numParticipatingNodes, numParticipatingPartitions);
        this.txnContextRepository.put(jobId, (IGlobalTransactionContext)context);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(JobId jobId) throws ACIDException {
        IGlobalTransactionContext iGlobalTransactionContext;
        IGlobalTransactionContext context = this.getTransactionContext(jobId);
        if (context.getAcksReceived() != context.getNumPartitions()) {
            iGlobalTransactionContext = context;
            synchronized (iGlobalTransactionContext) {
                try {
                    context.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ACIDException((Throwable)e);
                }
            }
        }
        context.setTxnStatus(IGlobalTxManager.TransactionStatus.PREPARED);
        context.persist(this.ioManager);
        context.resetAcksReceived();
        this.sendJobCommitMessages(context);
        iGlobalTransactionContext = context;
        synchronized (iGlobalTransactionContext) {
            try {
                CCConfig config = ((ClusterControllerService)this.serviceContext.getControllerService()).getCCConfig();
                context.wait(config.getGlobalTxCommitTimeout());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ACIDException((Throwable)e);
            }
        }
        this.txnContextRepository.remove(jobId);
    }

    public IGlobalTransactionContext getTransactionContext(JobId jobId) throws ACIDException {
        IGlobalTransactionContext context = this.txnContextRepository.get(jobId);
        if (context == null) {
            throw new ACIDException("Transaction for jobId " + jobId + " does not exist");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleJobPreparedMessage(JobId jobId, String nodeId, Map<String, ILSMComponentId> componentIdMap) {
        IGlobalTransactionContext context = this.txnContextRepository.get(jobId);
        if (context == null) {
            LOGGER.warn("JobPreparedMessage received for jobId " + jobId + ", which does not exist. The transaction for the job is already aborted");
            return;
        }
        if (context.getNodeResourceMap().containsKey(nodeId)) {
            ((Map)context.getNodeResourceMap().get(nodeId)).putAll(componentIdMap);
        } else {
            context.getNodeResourceMap().put(nodeId, componentIdMap);
        }
        if (context.incrementAndGetAcksReceived() == context.getNumPartitions()) {
            IGlobalTransactionContext iGlobalTransactionContext = context;
            synchronized (iGlobalTransactionContext) {
                context.notifyAll();
            }
        }
    }

    private void sendJobCommitMessages(IGlobalTransactionContext context) {
        for (String nodeId : context.getNodeResourceMap().keySet()) {
            AtomicJobCommitMessage message = new AtomicJobCommitMessage(context.getJobId(), context.getDatasetIds());
            try {
                ((ICCMessageBroker)this.serviceContext.getMessageBroker()).sendRealTimeApplicationMessageToNC((INcAddressedMessage)message, nodeId);
            }
            catch (Exception e) {
                throw new ACIDException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleJobCompletionMessage(JobId jobId, String nodeId) {
        IGlobalTransactionContext context = this.getTransactionContext(jobId);
        if (context.incrementAndGetAcksReceived() == context.getNumNodes()) {
            context.delete(this.ioManager);
            context.setTxnStatus(IGlobalTxManager.TransactionStatus.COMMITTED);
            IGlobalTransactionContext iGlobalTransactionContext = context;
            synchronized (iGlobalTransactionContext) {
                context.notifyAll();
            }
            this.sendEnableMergeMessages(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleJobRollbackCompletionMessage(JobId jobId, String nodeId) {
        IGlobalTransactionContext context = this.getTransactionContext(jobId);
        if (context.incrementAndGetAcksReceived() == context.getNumNodes()) {
            context.setTxnStatus(IGlobalTxManager.TransactionStatus.ROLLBACK);
            context.delete(this.ioManager);
            IGlobalTransactionContext iGlobalTransactionContext = context;
            synchronized (iGlobalTransactionContext) {
                context.notifyAll();
            }
        }
    }

    private void sendEnableMergeMessages(IGlobalTransactionContext context) {
        for (String nodeId : context.getNodeResourceMap().keySet()) {
            for (Integer datasetId : context.getDatasetIds()) {
                EnableMergeMessage message = new EnableMergeMessage(context.getJobId(), datasetId);
                try {
                    ((ICCMessageBroker)this.serviceContext.getMessageBroker()).sendRealTimeApplicationMessageToNC((INcAddressedMessage)message, nodeId);
                }
                catch (Exception e) {
                    throw new ACIDException((Throwable)e);
                }
            }
        }
    }

    public void rollback() throws Exception {
        Set txnLogFileRefs = this.ioManager.list(this.ioManager.resolve("."));
        for (FileReference txnLogFileRef : txnLogFileRefs) {
            GlobalTransactionContext context = new GlobalTransactionContext(txnLogFileRef, this.ioManager);
            this.txnContextRepository.put(context.getJobId(), (IGlobalTransactionContext)context);
            this.sendJobRollbackMessages((IGlobalTransactionContext)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJobRollbackMessages(IGlobalTransactionContext context) throws Exception {
        JobId jobId = context.getJobId();
        for (String nodeId : context.getNodeResourceMap().keySet()) {
            AtomicJobRollbackMessage rollbackMessage = new AtomicJobRollbackMessage(jobId, context.getDatasetIds(), (Map)context.getNodeResourceMap().get(nodeId));
            ((ICCMessageBroker)this.serviceContext.getMessageBroker()).sendRealTimeApplicationMessageToNC((INcAddressedMessage)rollbackMessage, nodeId);
        }
        IGlobalTransactionContext iGlobalTransactionContext = context;
        synchronized (iGlobalTransactionContext) {
            try {
                CCConfig config = ((ClusterControllerService)this.serviceContext.getControllerService()).getCCConfig();
                context.wait(config.getGlobalTxRollbackTimeout());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Error while rolling back atomic statement for {}, halting JVM", (Object)jobId);
                ExitUtil.halt((int)24);
            }
        }
        this.txnContextRepository.remove(jobId);
    }

    public void abortTransaction(JobId jobId) throws Exception {
        IGlobalTransactionContext context = this.getTransactionContext(jobId);
        if (context.getTxnStatus() == IGlobalTxManager.TransactionStatus.PREPARED) {
            this.sendJobRollbackMessages(context);
        }
        this.txnContextRepository.remove(jobId);
    }

    public void notifyJobCreation(JobId jobId, JobSpecification spec) throws HyracksException {
        GlobalTxInfo globalTxInfo = (GlobalTxInfo)spec.getProperty(GlOBAL_TX_PROPERTY_NAME);
        if (globalTxInfo != null) {
            this.beginTransaction(jobId, globalTxInfo.getNumNodes(), globalTxInfo.getNumPartitions(), globalTxInfo.getDatasetIds());
        }
    }

    public void notifyJobStart(JobId jobId) throws HyracksException {
    }

    public void notifyJobFinish(JobId jobId, JobStatus jobStatus, List<Exception> exceptions) throws HyracksException {
    }
}

