/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.Serializable;
import java.util.List;
import org.apache.asterix.app.function.FunctionRewriter;
import org.apache.asterix.app.function.StorageComponentsDatasource;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class StorageComponentsRewriter
extends FunctionRewriter {
    public static final FunctionIdentifier STORAGE_COMPONENTS = FunctionConstants.newAsterix((String)"storage-components", (int)-1);
    public static final StorageComponentsRewriter INSTANCE = new StorageComponentsRewriter(STORAGE_COMPONENTS);

    private StorageComponentsRewriter(FunctionIdentifier functionId) {
        super(functionId);
    }

    @Override
    public StorageComponentsDatasource toDatasource(IOptimizationContext context, AbstractFunctionCallExpression f) throws AlgebricksException {
        SourceLocation loc = f.getSourceLocation();
        DataverseName dataverseName = this.getDataverseName(loc, f.getArguments(), 0);
        String datasetName = this.getString(loc, f.getArguments(), 1);
        String database = f.getArguments().size() > 2 ? this.getString(loc, f.getArguments(), 2) : MetadataUtil.databaseFor((DataverseName)dataverseName);
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        Dataset dataset = metadataProvider.findDataset(database, dataverseName, datasetName);
        if (dataset == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, loc, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)database, (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
        }
        return new StorageComponentsDatasource(context.getComputationNodeDomain(), dataset.getDatasetId());
    }

    @Override
    protected boolean invalidArgs(List<Mutable<ILogicalExpression>> args) {
        return args.size() < 2;
    }
}

