/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Set;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.optimizer.base.AsterixOptimizationContext;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.PushdownProcessorsExecutor;
import org.apache.asterix.optimizer.rules.pushdown.processor.ColumnFilterPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.processor.ColumnRangeFilterPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.processor.ColumnValueAccessPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.processor.ConsolidateProjectionAndFilterExpressionsProcessor;
import org.apache.asterix.optimizer.rules.pushdown.processor.ExternalDatasetFilterPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.processor.InlineAndNormalizeFilterExpressionsProcessor;
import org.apache.asterix.optimizer.rules.pushdown.visitor.PushdownOperatorVisitor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushValueAccessAndFilterDownRule
implements IAlgebraicRewriteRule {
    private boolean run = true;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (!context.getPhysicalOptimizationConfig().isExternalFieldPushdown() || !this.run) {
            return false;
        }
        this.run = this.shouldRun(context);
        boolean changed = false;
        if (this.run) {
            PushdownContext pushdownContext = new PushdownContext(context);
            PushdownOperatorVisitor pushdownInfoComputer = new PushdownOperatorVisitor(pushdownContext, context);
            ((ILogicalOperator)opRef.getValue()).accept((ILogicalOperatorVisitor)pushdownInfoComputer, null);
            PushdownProcessorsExecutor pushdownProcessorsExecutor = new PushdownProcessorsExecutor();
            this.addProcessors(pushdownProcessorsExecutor, pushdownContext, context);
            changed = pushdownProcessorsExecutor.execute();
            pushdownProcessorsExecutor.finalizePushdown(pushdownContext, context);
            this.run = false;
        }
        return changed;
    }

    private void addProcessors(PushdownProcessorsExecutor pushdownProcessorsExecutor, PushdownContext pushdownContext, IOptimizationContext context) {
        pushdownProcessorsExecutor.add(new ColumnValueAccessPushdownProcessor(pushdownContext, context));
        if (context.getPhysicalOptimizationConfig().isColumnFilterEnabled()) {
            pushdownProcessorsExecutor.add(new ColumnFilterPushdownProcessor(pushdownContext, context));
            pushdownProcessorsExecutor.add(new ColumnRangeFilterPushdownProcessor(pushdownContext, context));
        }
        pushdownProcessorsExecutor.add(new ExternalDatasetFilterPushdownProcessor(pushdownContext, context));
        pushdownProcessorsExecutor.add(new ConsolidateProjectionAndFilterExpressionsProcessor(pushdownContext, context));
        pushdownProcessorsExecutor.add(new InlineAndNormalizeFilterExpressionsProcessor(pushdownContext, context));
    }

    private boolean shouldRun(IOptimizationContext context) throws AlgebricksException {
        ObjectSet entrySet = ((AsterixOptimizationContext)context).getDataSourceMap().int2ObjectEntrySet();
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        for (Int2ObjectMap.Entry dataSources : entrySet) {
            for (DataSource dataSource : (Set)dataSources.getValue()) {
                if (!this.supportPushdown(metadataProvider, dataSource)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean supportPushdown(MetadataProvider metadataProvider, DataSource dataSource) throws AlgebricksException {
        DataverseName dataverse = dataSource.getId().getDataverseName();
        String datasetName = dataSource.getId().getDatasourceName();
        String database = dataSource.getId().getDatabaseName();
        Dataset dataset = metadataProvider.findDataset(database, dataverse, datasetName);
        return dataset != null && (DatasetUtil.isFieldAccessPushdownSupported((Dataset)dataset) || DatasetUtil.isFilterPushdownSupported((Dataset)dataset) || DatasetUtil.isRangeFilterPushdownSupported((Dataset)dataset));
    }
}

