/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractArrayAddRemoveEval;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.asterix.runtime.utils.DescriptorFactoryUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class ArrayPutDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType[] argTypes;
    public static final IFunctionDescriptorFactory FACTORY = DescriptorFactoryUtil.createFactory(ArrayPutDescriptor::new, FunctionTypeInferers.SET_ARGUMENTS_TYPE);

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_PUT;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayPutEval(args, ctx);
            }
        };
    }

    public void setImmutableStates(Object ... states) {
        this.argTypes = (IAType[])states;
    }

    public class ArrayPutEval
    extends AbstractArrayAddRemoveEval {
        private final ArrayBackedValueStorage storage;
        private final IPointable item;
        private final IBinaryComparator comp;
        private final boolean[] add;

        ArrayPutEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            super(args, ctx, 0, 1, args.length - 1, ArrayPutDescriptor.this.argTypes, true, false);
            this.comp = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)BuiltinType.ANY, (Object)BuiltinType.ANY, true).createBinaryComparator();
            this.storage = new ArrayBackedValueStorage();
            this.item = new VoidPointable();
            this.add = new boolean[args.length - 1];
        }

        @Override
        protected void processList(ListAccessor listAccessor, IAsterixListBuilder listBuilder, IPointable[] values, int position) throws IOException {
            int i;
            this.markAllToBeAdded();
            for (i = 0; i < listAccessor.size(); ++i) {
                listAccessor.getOrWriteItem(i, this.item, this.storage);
                listBuilder.addItem((IValueReference)this.item);
                for (int j = 0; j < values.length; ++j) {
                    if (!this.add[j] || this.comp.compare(this.item.getByteArray(), this.item.getStartOffset(), this.item.getLength(), values[j].getByteArray(), values[j].getStartOffset(), values[j].getLength()) != 0) continue;
                    this.add[j] = false;
                }
            }
            for (i = 0; i < values.length; ++i) {
                if (!this.add[i]) continue;
                listBuilder.addItem((IValueReference)values[i]);
            }
        }

        private void markAllToBeAdded() {
            for (int i = 0; i < this.add.length; ++i) {
                this.add[i] = true;
            }
        }
    }
}

