/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.records.AbstractRecordFunctionEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

abstract class AbstractRecordAddPutEvaluator
extends AbstractRecordFunctionEvaluator {
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IScalarEvaluator eval2;
    protected boolean newFieldValueIsMissing = false;

    AbstractRecordAddPutEvaluator(IScalarEvaluator eval0, IScalarEvaluator eval1, IScalarEvaluator eval2, ARecordType outRecType, ARecordType inRecType) {
        super(outRecType, inRecType);
        this.eval0 = eval0;
        this.eval1 = eval1;
        this.eval2 = eval2;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.inputPointable);
        this.eval1.evaluate(tuple, this.newFieldNamePointable);
        this.eval2.evaluate(tuple, this.newFieldValuePointable);
        ATypeTag inputTypeTag = PointableHelper.getTypeTag((IValueReference)this.inputPointable);
        ATypeTag newFieldNameTypeTag = PointableHelper.getTypeTag((IValueReference)this.newFieldNamePointable);
        if (inputTypeTag == ATypeTag.MISSING || newFieldNameTypeTag == ATypeTag.MISSING) {
            PointableHelper.setMissing(result);
            return;
        }
        if (inputTypeTag != ATypeTag.OBJECT || newFieldNameTypeTag != ATypeTag.STRING) {
            PointableHelper.setNull(result);
            return;
        }
        this.newFieldValueIsMissing = PointableHelper.getTypeTag((IValueReference)this.newFieldValuePointable) == ATypeTag.MISSING;
        this.outputRecordTypeInfo.reset(this.outRecType);
        if (this.inputRecordPointable == null) {
            this.inputRecordPointable = this.pointableAllocator.allocateRecordValue((IAType)this.inRecType);
        }
        this.buildOutputRecord(result);
        result.set((IValueReference)this.resultStorage);
    }

    protected abstract void buildOutputRecord(IPointable var1) throws HyracksDataException;

    protected void addField(IPointable fieldName, IPointable fieldValue) throws HyracksDataException {
        int pos = this.outputRecordTypeInfo.getFieldIndex(fieldName.getByteArray(), fieldName.getStartOffset() + 1, fieldName.getLength() - 1);
        if (pos >= 0) {
            this.outRecordBuilder.addField(pos, (IValueReference)fieldValue);
        } else {
            this.outRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
        }
    }
}

