/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.net.SocketAddress;
import java.util.Map;
import org.apache.hyracks.api.channels.IInputChannel;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.comm.PartitionChannel;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.comm.channels.IChannelConnectionFactory;
import org.apache.hyracks.comm.channels.NetworkInputChannel;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NodeControllerService;

public class ReportPartitionAvailabilityWork
extends AbstractWork {
    private final NodeControllerService ncs;
    private final PartitionId pid;
    private final NetworkAddress networkAddress;

    public ReportPartitionAvailabilityWork(NodeControllerService ncs, PartitionId pid, NetworkAddress networkAddress) {
        this.ncs = ncs;
        this.pid = pid;
        this.networkAddress = networkAddress;
    }

    public void run() {
        try {
            Map<JobId, Joblet> jobletMap = this.ncs.getJobletMap();
            Joblet ji = jobletMap.get(this.pid.getJobId());
            if (ji != null) {
                PartitionChannel channel = new PartitionChannel(this.pid, (IInputChannel)new NetworkInputChannel((IChannelConnectionFactory)this.ncs.getNetworkManager(), (SocketAddress)this.networkAddress.toResolvedInetSocketAddress(), this.pid, 5));
                ji.reportPartitionAvailability(channel);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

