/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.SystemProperties;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class PartitionsTable
extends BaseMetadataTable {
    private final Schema schema;
    static final boolean PLAN_SCANS_WITH_WORKER_POOL = SystemProperties.getBoolean("iceberg.scan.plan-in-worker-pool", true);

    PartitionsTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".partitions");
    }

    PartitionsTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
        this.schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"partition", (Type)Partitioning.partitionType(table)), Types.NestedField.required((int)2, (String)"record_count", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"file_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"spec_id", (Type)Types.IntegerType.get())});
    }

    public TableScan newScan() {
        return new PartitionsScan(this.operations(), this.table());
    }

    public Schema schema() {
        if (this.table().spec().fields().size() < 1) {
            return this.schema.select(new String[]{"record_count", "file_count"});
        }
        return this.schema;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.PARTITIONS;
    }

    private DataTask task(StaticTableScan scan) {
        TableOperations ops = this.operations();
        Iterable<Partition> partitions = PartitionsTable.partitions(this.table(), scan);
        if (this.table().spec().fields().size() < 1) {
            return StaticDataTask.of(this.io().newInputFile(ops.current().metadataFileLocation()), this.schema(), scan.schema(), partitions, root -> StaticDataTask.Row.of(((Partition)root).recordCount, ((Partition)root).fileCount));
        }
        return StaticDataTask.of(this.io().newInputFile(ops.current().metadataFileLocation()), this.schema(), scan.schema(), partitions, PartitionsTable::convertPartition);
    }

    private static StaticDataTask.Row convertPartition(Partition partition) {
        return StaticDataTask.Row.of(partition.key, partition.recordCount, partition.fileCount, partition.specId);
    }

    private static Iterable<Partition> partitions(Table table, StaticTableScan scan) {
        CloseableIterable<FileScanTask> tasks = PartitionsTable.planFiles(scan);
        Types.StructType normalizedPartitionType = Partitioning.partitionType(table);
        PartitionMap partitions = new PartitionMap();
        HashMap normalizedPositionsBySpec = Maps.newHashMapWithExpectedSize((int)table.specs().size());
        for (FileScanTask task : tasks) {
            PartitionData original = (PartitionData)((DataFile)task.file()).partition();
            int[] normalizedPositions = normalizedPositionsBySpec.computeIfAbsent(task.spec().specId(), specId -> PartitionsTable.normalizedPositions(table, specId, normalizedPartitionType));
            PartitionData normalized = PartitionsTable.normalizePartition(original, normalizedPartitionType, normalizedPositions);
            partitions.get(normalized).update((DataFile)task.file());
        }
        return partitions.all();
    }

    private static int[] normalizedPositions(Table table, int specId, Types.StructType normalizedType) {
        Types.StructType originalType = ((PartitionSpec)table.specs().get(specId)).partitionType();
        int[] normalizedPositions = new int[originalType.fields().size()];
        for (int originalIndex = 0; originalIndex < originalType.fields().size(); ++originalIndex) {
            Types.NestedField normalizedField = normalizedType.field(((Types.NestedField)originalType.fields().get(originalIndex)).fieldId());
            normalizedPositions[originalIndex] = normalizedType.fields().indexOf(normalizedField);
        }
        return normalizedPositions;
    }

    private static PartitionData normalizePartition(PartitionData originalPartition, Types.StructType normalizedPartitionType, int[] normalizedPositions) {
        PartitionData normalizedPartition = new PartitionData(normalizedPartitionType);
        for (int originalIndex = 0; originalIndex < originalPartition.size(); ++originalIndex) {
            normalizedPartition.put(normalizedPositions[originalIndex], originalPartition.get(originalIndex));
        }
        return normalizedPartition;
    }

    @VisibleForTesting
    static CloseableIterable<FileScanTask> planFiles(StaticTableScan scan) {
        Table table = scan.table();
        Snapshot snapshot = table.snapshot(scan.snapshot().snapshotId());
        boolean caseSensitive = scan.isCaseSensitive();
        LoadingCache evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = (PartitionSpec)table.specs().get(specId);
            PartitionSpec transformedSpec = PartitionsTable.transformSpec(scan.tableSchema(), spec);
            return ManifestEvaluator.forRowFilter((Expression)scan.filter(), (PartitionSpec)transformedSpec, (boolean)caseSensitive);
        });
        FileIO io = table.io();
        ManifestGroup manifestGroup = new ManifestGroup(io, snapshot.dataManifests(io), snapshot.deleteManifests(io)).caseSensitive(caseSensitive).filterManifests(m -> ((ManifestEvaluator)evalCache.get((Object)m.partitionSpecId())).eval(m)).select(scan.scanColumns()).specsById(scan.table().specs()).ignoreDeleted();
        if (scan.shouldIgnoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (scan.snapshot().dataManifests(io).size() > 1 && (PLAN_SCANS_WITH_WORKER_POOL || scan.context().planWithCustomizedExecutor())) {
            manifestGroup = manifestGroup.planWith(scan.context().planExecutor());
        }
        return manifestGroup.planFiles();
    }

    static class Partition {
        private final StructLike key;
        private long recordCount;
        private int fileCount;
        private int specId;

        Partition(StructLike key) {
            this.key = key;
            this.recordCount = 0L;
            this.fileCount = 0;
            this.specId = 0;
        }

        void update(DataFile file) {
            this.recordCount += file.recordCount();
            ++this.fileCount;
            this.specId = file.specId();
        }
    }

    static class PartitionMap {
        private final Map<PartitionData, Partition> partitions = Maps.newHashMap();

        PartitionMap() {
        }

        Partition get(PartitionData key) {
            Partition partition = this.partitions.get(key);
            if (partition == null) {
                partition = new Partition(key);
                this.partitions.put(key, partition);
            }
            return partition;
        }

        Iterable<Partition> all() {
            return this.partitions.values();
        }
    }

    private class PartitionsScan
    extends StaticTableScan {
        PartitionsScan(TableOperations ops, Table table) {
            super(ops, table, PartitionsTable.this.schema(), MetadataTableType.PARTITIONS, (StaticTableScan x$0) -> PartitionsTable.this.task(x$0));
        }
    }
}

