/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import org.apache.hyracks.http.api.IChannelClosedHandler;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.HttpRequestHandler;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpServerHandler<T extends HttpServer>
extends SimpleChannelInboundHandler<Object>
implements ChannelFutureListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PIPELINED_REQUEST_ERROR_MSG = "Server doesn't support pipelined requests";
    protected final T server;
    protected volatile HttpRequestHandler handler;
    protected volatile Future<Void> task;
    protected volatile IServlet servlet;
    private volatile IChannelClosedHandler closeHandler;
    private volatile boolean pipelinedRequest = false;
    private final int chunkSize;

    public HttpServerHandler(T server, int chunkSize) {
        this.server = server;
        this.chunkSize = chunkSize;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        HttpRequestHandler currentHandler = this.handler;
        if (currentHandler != null && ctx.channel().isWritable()) {
            currentHandler.notifyChannelWritable();
        }
        super.channelWritabilityChanged(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        HttpRequestHandler currentHandler = this.handler;
        if (currentHandler != null) {
            currentHandler.notifyChannelInactive();
        }
        IChannelClosedHandler currentCloseHandler = this.closeHandler;
        IServlet currentServlet = this.servlet;
        Future<Void> currentTask = this.task;
        if (currentCloseHandler != null && currentServlet != null && currentTask != null) {
            currentCloseHandler.channelClosed((HttpServer)this.server, currentServlet, currentTask);
        }
        super.channelInactive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        FullHttpRequest request = (FullHttpRequest)msg;
        if (this.isPipelinedRequest()) {
            this.pipelinedRequest = true;
            this.rejectPipelinedRequestAndClose(ctx, request);
            return;
        }
        if (request.decoderResult().isFailure()) {
            this.respond(ctx, (HttpRequest)request, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        try {
            this.servlet = ((HttpServer)this.server).getServlet(request);
            if (this.servlet == null) {
                this.handleServletNotFound(ctx, request);
            } else {
                this.submit(ctx, this.servlet, request);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failure handling HTTP request", (Throwable)e);
            this.respond(ctx, (HttpRequest)request, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected void respond(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus status) {
        this.respond(ctx, request, status, null);
    }

    protected void respond(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus status, Consumer<HttpResponse> beforeWrite) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), status);
        response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
        HttpUtil.setConnectionHeader(request, (DefaultHttpResponse)response);
        ChannelPromise responseCompletionPromise = ctx.newPromise();
        responseCompletionPromise.addListener((GenericFutureListener)this);
        if (beforeWrite != null) {
            beforeWrite.accept((HttpResponse)response);
        }
        ChannelFuture clientChannel = ctx.writeAndFlush((Object)response, responseCompletionPromise);
        if (!io.netty.handler.codec.http.HttpUtil.isKeepAlive((HttpMessage)request)) {
            clientChannel.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void submit(ChannelHandlerContext ctx, IServlet servlet, FullHttpRequest request) throws IOException {
        IServletRequest servletRequest;
        try {
            HttpScheme scheme = HttpUtil.getScheme(this.server, request);
            boolean ignoreParam = servlet.ignoresQueryParameters(request.method());
            servletRequest = this.createServletRequest(ctx, request, scheme, ignoreParam);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARN, "Failure Decoding Request", (Throwable)e);
            this.respond(ctx, (HttpRequest)request, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        this.handler = new HttpRequestHandler(this, ctx, servlet, servletRequest, this.chunkSize);
        this.submit(servlet);
    }

    private void submit(IServlet servlet) throws IOException {
        try {
            this.task = ((HttpServer)this.server).getExecutor(this.handler).submit(this.handler);
            this.closeHandler = servlet.getChannelClosedHandler((HttpServer)this.server);
        }
        catch (RejectedExecutionException e) {
            LOGGER.log(Level.WARN, "Request rejected by server executor service. " + e.getMessage());
            this.handler.reject();
        }
    }

    protected void handleServletNotFound(ChannelHandlerContext ctx, FullHttpRequest request) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No servlet for " + request.uri());
        }
        this.respond(ctx, (HttpRequest)request, HttpResponseStatus.NOT_FOUND, response -> response.headers().set((CharSequence)HttpUtil.PERMANENT, (Object)"true"));
    }

    protected IServletRequest createServletRequest(ChannelHandlerContext ctx, FullHttpRequest request, HttpScheme scheme, boolean ignoreQueryParameters) {
        return HttpUtil.toServletRequest(ctx, request, scheme, ignoreQueryParameters);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.log(Level.WARN, "Failure handling HTTP Request", cause);
        ctx.close();
    }

    public void operationComplete(ChannelFuture future) {
        if (!this.pipelinedRequest) {
            this.requestHandled();
        }
    }

    private boolean isPipelinedRequest() {
        return this.handler != null || this.servlet != null || this.closeHandler != null || this.task != null;
    }

    private void rejectPipelinedRequestAndClose(ChannelHandlerContext ctx, FullHttpRequest request) {
        LOGGER.warn(PIPELINED_REQUEST_ERROR_MSG);
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        this.respond(ctx, (HttpRequest)request, new HttpResponseStatus(HttpResponseStatus.BAD_REQUEST.code(), PIPELINED_REQUEST_ERROR_MSG));
    }

    private void requestHandled() {
        this.handler = null;
        this.servlet = null;
        this.task = null;
        this.closeHandler = null;
    }
}

