/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import com.google.common.collect.ImmutableList;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.bootstrap.FullTextConfigEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.fulltext.FullTextConfigDescriptor;
import org.apache.commons.lang3.EnumUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.TokenizerCategory;

public class FullTextConfigMetadataEntityTupleTranslator
extends AbstractTupleTranslator<FullTextConfigMetadataEntity> {
    private final FullTextConfigEntity fullTextConfigEntity;
    protected final ArrayTupleReference tuple;

    protected FullTextConfigMetadataEntityTupleTranslator(boolean getTuple, FullTextConfigEntity fullTextConfigEntity) {
        super(getTuple, fullTextConfigEntity.getIndex(), fullTextConfigEntity.payloadPosition());
        this.fullTextConfigEntity = fullTextConfigEntity;
        this.tuple = getTuple ? new ArrayTupleReference() : null;
    }

    @Override
    protected FullTextConfigMetadataEntity createMetadataEntityFromARecord(ARecord aRecord) throws HyracksDataException, AlgebricksException {
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)((AString)aRecord.getValueByPos(this.fullTextConfigEntity.dataverseNameIndex())).getStringValue());
        int databaseNameIndex = this.fullTextConfigEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)aRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String name = ((AString)aRecord.getValueByPos(this.fullTextConfigEntity.configNameIndex())).getStringValue();
        TokenizerCategory tokenizerCategory = (TokenizerCategory)EnumUtils.getEnumIgnoreCase(TokenizerCategory.class, (String)((AString)aRecord.getValueByPos(this.fullTextConfigEntity.tokenizerIndex())).getStringValue());
        ImmutableList.Builder filterNamesBuilder = ImmutableList.builder();
        IACursor filterNamesCursor = ((AOrderedList)aRecord.getValueByPos(this.fullTextConfigEntity.filterPipelineIndex())).getCursor();
        while (filterNamesCursor.next()) {
            filterNamesBuilder.add((Object)((AString)filterNamesCursor.get()).getStringValue());
        }
        FullTextConfigDescriptor configDescriptor = new FullTextConfigDescriptor(databaseName, dataverseName, name, tokenizerCategory, filterNamesBuilder.build());
        return new FullTextConfigMetadataEntity(configDescriptor);
    }

    private void writeIndex(String databaseName, String dataverseName, String configName, ArrayTupleBuilder tupleBuilder) throws HyracksDataException {
        if (this.fullTextConfigEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(databaseName);
            this.stringSerde.serialize((Object)this.aString, tupleBuilder.getDataOutput());
            tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseName);
        this.stringSerde.serialize((Object)this.aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        this.aString.setValue(configName);
        this.stringSerde.serialize((Object)this.aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(FullTextConfigMetadataEntity configMetadataEntity) throws HyracksDataException {
        this.tupleBuilder.reset();
        FullTextConfigDescriptor configDescriptor = configMetadataEntity.getFullTextConfig();
        this.writeIndex(configDescriptor.getDatabaseName(), configDescriptor.getDataverseName().getCanonicalForm(), configDescriptor.getName(), this.tupleBuilder);
        this.recordBuilder.reset(this.fullTextConfigEntity.getRecordType());
        if (this.fullTextConfigEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(configDescriptor.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.fullTextConfigEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(configDescriptor.getDataverseName().getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.fullTextConfigEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(configDescriptor.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.fullTextConfigEntity.configNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(configDescriptor.getTokenizerCategory().name());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.fullTextConfigEntity.tokenizerIndex(), (IValueReference)this.fieldValue);
        ImmutableList filterNames = configDescriptor.getFilterNames();
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        listBuilder.reset((AbstractCollectionType)new AOrderedListType((IAType)BuiltinType.ASTRING, null));
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        for (String s : filterNames) {
            itemValue.reset();
            this.aString.setValue(s);
            this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(this.fullTextConfigEntity.filterPipelineIndex(), (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

