/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.jetty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.ResponderServlet;
import org.apache.avro.ipc.Server;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class HttpServer
implements Server {
    private org.eclipse.jetty.server.Server server;

    public HttpServer(Responder responder, int port) throws IOException {
        this(new ResponderServlet(responder), null, port);
    }

    public HttpServer(ResponderServlet servlet, int port) throws IOException {
        this(servlet, null, port);
    }

    public HttpServer(Responder responder, InetSocketAddress addr) throws IOException {
        this(new ResponderServlet(responder), addr.getHostString(), addr.getPort());
    }

    public HttpServer(Responder responder, String bindAddress, int port) throws IOException {
        this(new ResponderServlet(responder), bindAddress, port);
    }

    public HttpServer(ResponderServlet servlet, String bindAddress, int port) throws IOException {
        this.server = new org.eclipse.jetty.server.Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setAcceptQueueSize(128);
        connector.setIdleTimeout(10000L);
        if (bindAddress != null) {
            connector.setHost(bindAddress);
        }
        connector.setPort(port);
        this.server.addConnector(connector);
        ServletHandler handler = new ServletHandler();
        handler.addServletWithMapping(new ServletHolder(servlet), "/*");
        ServletContextHandler sch = new ServletContextHandler();
        sch.setServletHandler(handler);
        this.server.setHandler(sch);
    }

    public HttpServer(Responder responder, ConnectionFactory connectionFactory, String bindAddress, int port) throws IOException {
        this(new ResponderServlet(responder), connectionFactory, bindAddress, port);
    }

    public HttpServer(ResponderServlet servlet, ConnectionFactory connectionFactory, String bindAddress, int port) throws IOException {
        this.server = new org.eclipse.jetty.server.Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(this.server, connectionFactory, httpFactory);
        if (bindAddress != null) {
            connector.setHost(bindAddress);
        }
        connector.setPort(port);
        this.server.addConnector(connector);
        ServletHandler handler = new ServletHandler();
        this.server.setHandler(handler);
        handler.addServletWithMapping(new ServletHolder(servlet), "/*");
    }

    @Deprecated
    public HttpServer(ResponderServlet servlet, Connector connector) throws IOException {
        this.server = connector.getServer();
        if (this.server.getConnectors().length == 0 || Arrays.asList(this.server.getConnectors()).contains(connector)) {
            this.server.addConnector(connector);
        }
        ServletHandler handler = new ServletHandler();
        this.server.setHandler(handler);
        handler.addServletWithMapping(new ServletHolder(servlet), "/*");
    }

    @Deprecated
    public HttpServer(Responder responder, Connector connector) throws IOException {
        this(new ResponderServlet(responder), connector);
    }

    public void addConnector(Connector connector) {
        this.server.addConnector(connector);
    }

    @Override
    public int getPort() {
        return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    @Override
    public void close() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    public void join() throws InterruptedException {
        this.server.join();
    }
}

