/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.twitter.common.stats.SampledStat;
import com.twitter.common.stats.Stat;
import com.twitter.common.stats.Stats;

public class Ratio
extends SampledStat<Double> {
    private final Supplier<Number> numeratorAccessor;
    private final Supplier<Number> denominatorAccessor;

    private Ratio(String name, Supplier<Number> numeratorAccessor, Supplier<Number> denominatorAccessor) {
        super(name, 0.0);
        this.numeratorAccessor = (Supplier)Preconditions.checkNotNull(numeratorAccessor);
        this.denominatorAccessor = (Supplier)Preconditions.checkNotNull(denominatorAccessor);
    }

    public static <T extends Number> Ratio of(Stat<T> numerator, Stat<T> denominator) {
        Preconditions.checkNotNull(numerator);
        Preconditions.checkNotNull(denominator);
        String name = String.format("%s_per_%s", numerator.getName(), denominator.getName());
        return Ratio.of(name, numerator, denominator);
    }

    public static <T extends Number> Ratio of(String name, final Stat<T> numerator, final Stat<T> denominator) {
        Preconditions.checkNotNull(numerator);
        Preconditions.checkNotNull(denominator);
        Stats.export(numerator);
        Stats.export(denominator);
        return new Ratio(name, new Supplier<Number>(){

            public Number get() {
                return (Number)numerator.read();
            }
        }, new Supplier<Number>(){

            public Number get() {
                return (Number)denominator.read();
            }
        });
    }

    public static Ratio of(String name, final Number numerator, final Number denominator) {
        Preconditions.checkNotNull((Object)numerator);
        Preconditions.checkNotNull((Object)denominator);
        return new Ratio(name, new Supplier<Number>(){

            public Number get() {
                return numerator;
            }
        }, new Supplier<Number>(){

            public Number get() {
                return denominator;
            }
        });
    }

    @Override
    public Double doSample() {
        Double numeratorValue = ((Number)this.numeratorAccessor.get()).doubleValue();
        Double denominatorValue = ((Number)this.denominatorAccessor.get()).doubleValue();
        if (denominatorValue == 0.0 || denominatorValue.isNaN() || numeratorValue.isNaN()) {
            return 0.0;
        }
        return numeratorValue / denominatorValue;
    }
}

