/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.twitter.common.util.BackoffStrategy;
import com.twitter.common.util.concurrent.RetryingFutureTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class BackingOffFutureTask
extends RetryingFutureTask {
    private final ScheduledExecutorService executor;
    private final BackoffStrategy backoffStrategy;
    private long backoffMs = 0L;

    public BackingOffFutureTask(ScheduledExecutorService executor, Callable<Boolean> callable, int maxRetries, BackoffStrategy backoffStrategy) {
        super(executor, callable, maxRetries);
        this.executor = executor;
        this.backoffStrategy = (BackoffStrategy)Preconditions.checkNotNull((Object)backoffStrategy);
    }

    @Override
    protected void retry() {
        this.backoffMs = this.backoffStrategy.calculateBackoffMs(this.backoffMs);
        this.executor.schedule(this, this.backoffMs, TimeUnit.MILLISECONDS);
    }
}

