/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.zookeeper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.twitter.common.base.Function;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.io.Codec;
import com.twitter.common.zookeeper.CompoundServerSet;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.common.zookeeper.ServerSetImpl;
import com.twitter.common.zookeeper.ZooKeeperClient;
import com.twitter.thrift.Endpoint;
import com.twitter.thrift.ServiceInstance;
import com.twitter.thrift.Status;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import org.apache.zookeeper.data.ACL;

public class ServerSets {
    public static final Function<InetSocketAddress, Endpoint> TO_ENDPOINT = new Function<InetSocketAddress, Endpoint>(){

        public Endpoint apply(InetSocketAddress address) {
            return ServerSets.toEndpoint(address);
        }
    };

    private ServerSets() {
    }

    public static ServerSet create(ZooKeeperClient zkClient, Iterable<ACL> acl, String zkPath) {
        return ServerSets.create(zkClient, acl, (Set<String>)ImmutableSet.of((Object)zkPath));
    }

    public static ServerSet create(ZooKeeperClient zkClient, Iterable<ACL> acl, Set<String> zkPaths) {
        Preconditions.checkNotNull((Object)zkClient);
        MorePreconditions.checkNotBlank(acl);
        MorePreconditions.checkNotBlank(zkPaths);
        if (zkPaths.size() == 1) {
            return new ServerSetImpl(zkClient, acl, (String)Iterables.getOnlyElement(zkPaths));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String path : zkPaths) {
            builder.add((Object)new ServerSetImpl(zkClient, acl, path));
        }
        return new CompoundServerSet((Iterable<ServerSet>)builder.build());
    }

    public static byte[] serializeServiceInstance(ServiceInstance serviceInstance, Codec<ServiceInstance> codec) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        codec.serialize((Object)serviceInstance, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] serializeServiceInstance(InetSocketAddress address, Map<String, Endpoint> additionalEndpoints, Status status, Codec<ServiceInstance> codec) throws IOException {
        ServiceInstance serviceInstance = new ServiceInstance(ServerSets.toEndpoint(address), additionalEndpoints, status);
        return ServerSets.serializeServiceInstance(serviceInstance, codec);
    }

    public static ServiceInstance deserializeServiceInstance(byte[] data, Codec<ServiceInstance> codec) throws IOException {
        return (ServiceInstance)codec.deserialize((InputStream)new ByteArrayInputStream(data));
    }

    public static Endpoint toEndpoint(InetSocketAddress address) {
        return new Endpoint(address.getHostName(), address.getPort());
    }
}

