/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.lang.model.element.PackageElement;
import org.openjdk.tools.javadoc.doclet.DocletEnvironment;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocFile;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class PackageListWriter
extends PrintWriter {
    private final Configuration configuration;
    private final Utils utils;

    public PackageListWriter(Configuration configuration) throws IOException {
        super(DocFile.createFileForOutput(configuration, DocPaths.PACKAGE_LIST).openWriter());
        this.configuration = configuration;
        this.utils = configuration.utils;
    }

    public static void generate(Configuration configuration) {
        try {
            PackageListWriter packgen = new PackageListWriter(configuration);
            packgen.generatePackageListFile(configuration.root);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.message.error("doclet.exception_encountered", exc.toString(), DocPaths.PACKAGE_LIST);
            throw new DocletAbortException(exc);
        }
    }

    protected void generatePackageListFile(DocletEnvironment root) {
        ArrayList<PackageElement> names = new ArrayList<PackageElement>();
        for (PackageElement pkg : this.configuration.packages) {
            if (this.configuration.nodeprecated && this.utils.isDeprecated(pkg)) continue;
            names.add(pkg);
        }
        names.stream().forEach(name -> this.println(name));
    }
}

