/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.beanutils2.converters.AbstractConverter;

public class InetAddressConverter
extends AbstractConverter<InetAddress> {
    public InetAddressConverter() {
    }

    public InetAddressConverter(InetAddress defaultValue) {
        super(defaultValue);
    }

    @Override
    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        if (InetAddress.class.isAssignableFrom(type)) {
            String stringValue = InetAddressConverter.toString(value);
            try {
                return type.cast(InetAddress.getByName(stringValue));
            }
            catch (UnknownHostException ex) {
                throw new IllegalArgumentException("Unable to get IP address of the named host.", ex);
            }
        }
        throw this.conversionException(type, value);
    }

    @Override
    protected Class<InetAddress> getDefaultType() {
        return InetAddress.class;
    }
}

