/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.codec.digest.PureJavaCrc32;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PureJavaCrc32Test {
    private final CRC32 theirs = new CRC32();
    private final PureJavaCrc32 ours = new PureJavaCrc32();

    PureJavaCrc32Test() {
    }

    private void checkOnBytes(byte[] bytes, boolean print) {
        this.theirs.reset();
        this.ours.reset();
        this.checkSame();
        for (byte b : bytes) {
            this.ours.update((int)b);
            this.theirs.update(b);
            this.checkSame();
        }
        if (print) {
            System.out.println("theirs:\t" + Long.toHexString(this.theirs.getValue()) + "\nours:\t" + Long.toHexString(this.ours.getValue()));
        }
        this.theirs.reset();
        this.ours.reset();
        this.ours.update(bytes, 0, bytes.length);
        this.theirs.update(bytes, 0, bytes.length);
        if (print) {
            System.out.println("theirs:\t" + Long.toHexString(this.theirs.getValue()) + "\nours:\t" + Long.toHexString(this.ours.getValue()));
        }
        this.checkSame();
        if (bytes.length >= 10) {
            this.ours.update(bytes, 5, 5);
            this.theirs.update(bytes, 5, 5);
            this.checkSame();
        }
    }

    private void checkSame() {
        Assertions.assertEquals((long)this.theirs.getValue(), (long)this.ours.getValue());
    }

    @Test
    void testCorrectness() throws Exception {
        this.checkSame();
        this.theirs.update(104);
        this.ours.update(104);
        this.checkSame();
        this.checkOnBytes(new byte[]{40, 60, 97, -70}, false);
        this.checkOnBytes("hello world!".getBytes(StandardCharsets.UTF_8), false);
        Random random1 = new Random();
        Random random2 = new Random();
        for (int i = 0; i < 10000; ++i) {
            byte[] randomBytes = new byte[random1.nextInt(2048)];
            random2.nextBytes(randomBytes);
            this.checkOnBytes(randomBytes, false);
        }
    }

    public static class Table {
        private final int[][] tables;

        public static void main(String[] args) throws FileNotFoundException {
            if (args.length != 1) {
                System.err.println("Usage: " + Table.class.getName() + " <polynomial>");
                System.exit(1);
            }
            long polynomial = Long.parseLong(args[0], 16);
            int i = 8;
            Table t = new Table(8, 16, polynomial);
            String s = t.toString();
            System.out.println(s);
            try (PrintStream out = new PrintStream(new FileOutputStream("table8.txt"), true);){
                out.println(s);
            }
        }

        private Table(int nBits, int nTables, long polynomial) {
            this.tables = new int[nTables][];
            int size = 1 << nBits;
            for (int i = 0; i < this.tables.length; ++i) {
                this.tables[i] = new int[size];
            }
            int[] first = this.tables[0];
            for (int i = 0; i < first.length; ++i) {
                int crc = i;
                for (int j = 0; j < nBits; ++j) {
                    if ((crc & 1) == 1) {
                        crc >>>= 1;
                        crc = (int)((long)crc ^ polynomial);
                        continue;
                    }
                    crc >>>= 1;
                }
                first[i] = crc;
            }
            int mask = first.length - 1;
            for (int j = 1; j < this.tables.length; ++j) {
                int[] previous = this.tables[j - 1];
                int[] current = this.tables[j];
                for (int i = 0; i < current.length; ++i) {
                    current[i] = previous[i] >>> nBits ^ first[previous[i] & mask];
                }
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            String tableFormat = String.format("T%d_", Integer.numberOfTrailingZeros(this.tables[0].length)) + "%d";
            String startFormat = "  private static final int " + tableFormat + "_start = %d*256;";
            for (int j = 0; j < this.tables.length; ++j) {
                b.append(String.format(startFormat, j, j));
                b.append("\n");
            }
            b.append("  private static final int[] T = new int[] {");
            for (String s : this.toStrings(tableFormat)) {
                b.append("\n");
                b.append(s);
            }
            b.setCharAt(b.length() - 2, '\n');
            b.append(" };\n");
            return b.toString();
        }

        String[] toStrings(String nameFormat) {
            String[] s = new String[this.tables.length];
            for (int j = 0; j < this.tables.length; ++j) {
                int[] t = this.tables[j];
                StringBuilder b = new StringBuilder();
                b.append(String.format("    /* " + nameFormat + " */", j));
                int i = 0;
                while (i < t.length) {
                    b.append("\n    ");
                    for (int k = 0; k < 4; ++k) {
                        b.append(String.format("0x%08X, ", t[i++]));
                    }
                }
                s[j] = b.toString();
            }
            return s;
        }
    }

    public static class PerformanceTest {
        public static final int MAX_LEN = 0x2000000;
        public static final int BYTES_PER_SIZE = 0x8000000;
        static final Class<? extends Checksum> zip = CRC32.class;
        static final List<Class<? extends Checksum>> CRCS = new ArrayList<Class<? extends Checksum>>();

        private static BenchResult doBench(Class<? extends Checksum> clazz, int numThreads, final byte[] bytes, final int size) throws Exception {
            int i;
            Thread[] threads = new Thread[numThreads];
            final BenchResult[] results = new BenchResult[threads.length];
            final int trials = 0x8000000 / size;
            final double mbProcessed = (double)(trials * size) / 1024.0 / 1024.0;
            final Constructor<? extends Checksum> ctor = clazz.getConstructor(new Class[0]);
            for (i = 0; i < threads.length; ++i) {
                final int index = i;
                threads[i] = new Thread(){
                    final Checksum crc;
                    {
                        this.crc = (Checksum)ctor.newInstance(new Object[0]);
                    }

                    @Override
                    public void run() {
                        long st = System.nanoTime();
                        this.crc.reset();
                        for (int trialIndex = 0; trialIndex < trials; ++trialIndex) {
                            this.crc.update(bytes, 0, size);
                        }
                        long et = System.nanoTime();
                        double secondsElapsed = (double)(et - st) / 1.0E9;
                        results[index] = new BenchResult(this.crc.getValue(), mbProcessed / secondsElapsed);
                    }
                };
            }
            for (Thread thread : threads) {
                thread.start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
            long expected = results[0].value;
            double sum = results[0].mbps;
            for (i = 1; i < results.length; ++i) {
                if (results[i].value != expected) {
                    throw new AssertionError((Object)(clazz.getSimpleName() + " results not matched."));
                }
                sum += results[i].mbps;
            }
            return new BenchResult(expected, sum / (double)results.length);
        }

        private static void doBench(List<Class<? extends Checksum>> crcs, byte[] bytes, int size, PrintStream out) throws Exception {
            String numBytesStr = " #Bytes ";
            String numThreadsStr = "#T";
            String diffStr = "% diff";
            out.print('|');
            PerformanceTest.printCell(" #Bytes ", 0, out);
            PerformanceTest.printCell("#T", 0, out);
            for (int i = 0; i < crcs.size(); ++i) {
                Class<? extends Checksum> c = crcs.get(i);
                out.print('|');
                PerformanceTest.printCell(c.getSimpleName(), 8, out);
                for (int j = 0; j < i; ++j) {
                    PerformanceTest.printCell("% diff", "% diff".length(), out);
                }
            }
            out.printf("\n", new Object[0]);
            for (int numThreads = 1; numThreads <= 16; numThreads <<= 1) {
                out.printf("|", new Object[0]);
                PerformanceTest.printCell(String.valueOf(size), " #Bytes ".length(), out);
                PerformanceTest.printCell(String.valueOf(numThreads), "#T".length(), out);
                BenchResult expected = null;
                ArrayList<BenchResult> previous = new ArrayList<BenchResult>();
                for (Class<? extends Checksum> c : crcs) {
                    System.gc();
                    BenchResult result = PerformanceTest.doBench(c, numThreads, bytes, size);
                    PerformanceTest.printCell(String.format("%9.1f", result.mbps), c.getSimpleName().length() + 1, out);
                    if (c == zip) {
                        expected = result;
                    } else if (expected == null) {
                        Assertions.fail((String)("The first class is " + c.getName() + " but not " + zip.getName()));
                    } else if (result.value != expected.value) {
                        Assertions.fail((String)(c + " has bugs!"));
                    }
                    for (BenchResult p : previous) {
                        double diff = (result.mbps - p.mbps) / p.mbps * 100.0;
                        PerformanceTest.printCell(String.format("%5.1f%%", diff), "% diff".length(), out);
                    }
                    previous.add(result);
                }
                out.printf("\n", new Object[0]);
            }
        }

        private static void doBench(List<Class<? extends Checksum>> crcs, PrintStream out) throws Exception {
            byte[] bytes = new byte[0x2000000];
            new Random().nextBytes(bytes);
            out.printf("\nPerformance Table (The unit is MB/sec; #T = #Theads)\n", new Object[0]);
            for (Class<? extends Checksum> c : crcs) {
                PerformanceTest.doBench(c, 1, bytes, 2);
                PerformanceTest.doBench(c, 1, bytes, 2101);
            }
            for (int size = 32; size <= 0x2000000; size <<= 1) {
                PerformanceTest.doBench(crcs, bytes, size, out);
            }
        }

        public static void main(String[] args) throws Exception {
            PerformanceTest.printSystemProperties(System.out);
            PerformanceTest.doBench(CRCS, System.out);
        }

        private static void printCell(String s, int width, PrintStream out) {
            int w = s.length() > width ? s.length() : width;
            out.printf(" %" + w + "s |", s);
        }

        private static void printSystemProperties(PrintStream out) {
            String[] names = new String[]{"java.version", "java.runtime.name", "java.runtime.version", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.vm.specification.version", "java.specification.version", "os.arch", "os.name", "os.version"};
            Properties p = System.getProperties();
            for (String n : names) {
                out.println(n + " = " + p.getProperty(n));
            }
        }

        static {
            CRCS.add(zip);
            CRCS.add(PureJavaCrc32.class);
        }

        private static final class BenchResult {
            final long value;
            final double mbps;

            BenchResult(long value, double mbps) {
                this.value = value;
                this.mbps = mbps;
            }
        }
    }
}

