/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.utils;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.crypto.cipher.CryptoCipher;

public final class ReflectionUtils {
    private static final Map<ClassLoader, Map<String, WeakReference<Class<?>>>> CACHE_CLASSES = new WeakHashMap();
    private static final ClassLoader CLASSLOADER;
    private static final Class<?> NEGATIVE_CACHE_SENTINEL;

    static {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        CLASSLOADER = threadClassLoader != null ? threadClassLoader : CryptoCipher.class.getClassLoader();
        NEGATIVE_CACHE_SENTINEL = NegativeCacheSentinel.class;
    }

    public static Class<?> getClassByName(String name) throws ClassNotFoundException {
        Class<?> ret = ReflectionUtils.getClassByNameOrNull(name);
        if (ret == null) {
            throw new ClassNotFoundException("Class " + name + " not found");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getClassByNameOrNull(String name) {
        Map map;
        Map<ClassLoader, Map<String, WeakReference<Class<?>>>> map2 = CACHE_CLASSES;
        synchronized (map2) {
            map = CACHE_CLASSES.computeIfAbsent(CLASSLOADER, k -> Collections.synchronizedMap(new WeakHashMap()));
        }
        Class<?> clazz = null;
        WeakReference ref = (WeakReference)map.get(name);
        if (ref != null) {
            clazz = (Class<?>)ref.get();
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name, true, CLASSLOADER);
            }
            catch (ClassNotFoundException e) {
                map.put(name, new WeakReference(NEGATIVE_CACHE_SENTINEL));
                return null;
            }
            map.put(name, new WeakReference(clazz));
            return clazz;
        }
        if (clazz == NEGATIVE_CACHE_SENTINEL) {
            return null;
        }
        return clazz;
    }

    public static <T> T newInstance(Class<T> klass, Object ... args) {
        try {
            Constructor<T> ctor;
            int argsLength = args.length;
            if (argsLength == 0) {
                ctor = klass.getDeclaredConstructor(new Class[0]);
            } else {
                Class[] argClses = new Class[argsLength];
                Arrays.setAll(argClses, i -> args[i].getClass());
                ctor = klass.getDeclaredConstructor(argClses);
            }
            ctor.setAccessible(true);
            return ctor.newInstance(args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ReflectionUtils() {
    }

    private static abstract class NegativeCacheSentinel {
        private NegativeCacheSentinel() {
        }
    }
}

